/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.forging;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import insane96mcp.iguanatweaksreborn.world.item.DurabilityModifier;
import insane96mcp.insanelib.InsaneLib;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class ForgeHammerItem
extends TieredItem
implements Vanishable,
DurabilityModifier {
    protected static final UUID ENTITY_REACH_UUID = UUID.fromString("cdec6524-49a5-465a-a61c-f53c2e637c48");
    public static final String FORGE_COOLDOWN_LANG = "iguanatweaksexpanded.hammer_cooldown";
    final int useCooldown;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ForgeHammerItem(Tier tier, int useCooldown, Item.Properties pProperties) {
        super(tier, pProperties);
        this.useCooldown = useCooldown;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)(2.0f + this.m_43314_().m_6631_()), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -3.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(ENTITY_REACH_UUID, "Tool modifier", -0.5, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public int getUseCooldown(@Nullable LivingEntity entity, ItemStack stack) {
        int cooldown = this.useCooldown;
        int efficiency = stack.getEnchantmentLevel(Enchantments.f_44984_);
        if (efficiency <= 0) {
            return cooldown;
        }
        return cooldown - efficiency * 2;
    }

    public float getDurabilityMultiplier(ItemStack stack) {
        return 0.33333334f;
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)((float)this.f_41371_ * this.getDurabilityMultiplier(stack));
    }

    public void onUse(Player player, ItemStack stack) {
        player.m_36335_().m_41524_((Item)this, Math.max(this.getUseCooldown((LivingEntity)player, stack), 10));
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            pStack.m_41622_(1, pEntityLiving, p_43276_ -> p_43276_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment == Enchantments.f_44984_ || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE || enchantment.f_44672_ == EnchantmentCategory.VANISHABLE;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)FORGE_COOLDOWN_LANG, (Object[])new Object[]{InsaneLib.ONE_DECIMAL_FORMATTER.format(Math.max((float)this.getUseCooldown(null, pStack) / 20.0f, 0.5f))}).m_130940_(ChatFormatting.DARK_GREEN)));
    }
}

