/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.forging;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.Forging;
import insane96mcp.iguanatweaksexpanded.setup.client.ISEBookCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeRecipe
implements Recipe<Container> {
    protected final RecipeType<?> type = (RecipeType)Forging.FORGE_RECIPE_TYPE.get();
    protected final ResourceLocation id;
    private final ISEBookCategory category;
    final Ingredient ingredient;
    final int ingredientAmount;
    final Ingredient gear;
    private final ItemStack result;
    protected final int smashesRequired;
    protected final float experience;

    public ForgeRecipe(ResourceLocation pId, ISEBookCategory pCategory, Ingredient ingredient, int ingredientAmount, Ingredient gear, ItemStack pResult, int smashesRequired, float experience) {
        this.category = pCategory;
        this.id = pId;
        this.ingredient = ingredient;
        this.ingredientAmount = ingredientAmount;
        this.gear = gear;
        this.result = pResult;
        this.smashesRequired = smashesRequired;
        this.experience = experience;
    }

    public boolean m_5818_(Container container, Level pLevel) {
        return this.ingredient.test(container.m_8020_(0)) && container.m_8020_(0).m_41613_() >= this.ingredientAmount && this.gear.test(container.m_8020_(1));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        nonnulllist.add((Object)this.gear);
        return nonnulllist;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getIngredientAmount() {
        return this.ingredientAmount;
    }

    public Ingredient getGear() {
        return this.gear;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Forging.FORGE_RECIPE_SERIALIZER.get();
    }

    public int getSmashesRequired() {
        return this.smashesRequired;
    }

    public float getExperience() {
        return this.experience;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public ISEBookCategory category() {
        return this.category;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Forging.FORGE.item().get());
    }

    public static class ForgeRecipeSerializer
    implements RecipeSerializer<ForgeRecipe> {
        private final CookieBaker<ForgeRecipe> factory = ForgeRecipe::new;

        public ForgeRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            ItemStack result;
            ISEBookCategory category = (ISEBookCategory)ISEBookCategory.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)pJson, (String)"category", null), (Enum)ISEBookCategory.FORGE_MISC);
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)pJson.getAsJsonObject("ingredient"));
            if (!pJson.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            int ingredientAmount = GsonHelper.m_13824_((JsonObject)pJson, (String)"amount", (int)1);
            Ingredient gear = Ingredient.m_43917_((JsonElement)pJson.getAsJsonObject("gear"));
            if (pJson.get("result").isJsonObject()) {
                result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"), (boolean)true, (boolean)true);
            } else {
                String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(resourcelocation));
            }
            int smashesRequired = GsonHelper.m_13927_((JsonObject)pJson, (String)"smashes_required");
            float experience = GsonHelper.m_13820_((JsonObject)pJson, (String)"experience", (float)0.0f);
            return this.factory.create(pRecipeId, category, ingredient, ingredientAmount, gear, result, smashesRequired, experience);
        }

        public ForgeRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ISEBookCategory category = (ISEBookCategory)pBuffer.m_130066_(ISEBookCategory.class);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            int ingredientAmount = pBuffer.m_130242_();
            Ingredient gear = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack result = pBuffer.m_130267_();
            int smashesRequired = pBuffer.m_130242_();
            float experience = pBuffer.readFloat();
            return this.factory.create(pRecipeId, category, ingredient, ingredientAmount, gear, result, smashesRequired, experience);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ForgeRecipe pRecipe) {
            pBuffer.m_130068_((Enum)pRecipe.category());
            pRecipe.getIngredient().m_43923_(pBuffer);
            pBuffer.m_130130_(pRecipe.getIngredientAmount());
            pRecipe.getGear().m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
            pBuffer.m_130130_(pRecipe.getSmashesRequired());
            pBuffer.writeFloat(pRecipe.getExperience());
        }

        public static interface CookieBaker<T extends ForgeRecipe> {
            public T create(ResourceLocation var1, ISEBookCategory var2, Ingredient var3, int var4, Ingredient var5, ItemStack var6, int var7, float var8);
        }
    }
}

