/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.forging;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.ForgeRecipe;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.Forging;
import insane96mcp.iguanatweaksexpanded.setup.client.ISEBookCategory;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ForgeRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final ISEBookCategory bookCategory;
    final Ingredient ingredient;
    final int ingredientAmount;
    final Ingredient gear;
    private final ItemStack result;
    protected final int smashesRequired;
    protected float experience;
    private final RecipeSerializer<? extends ForgeRecipe> serializer;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public ForgeRecipeBuilder(RecipeCategory pCategory, ISEBookCategory pBookCategory, Ingredient ingredient, int ingredientAmount, Ingredient gear, ItemStack pResult, int smashesRequired, RecipeSerializer<? extends ForgeRecipe> pSerializer) {
        this.category = pCategory;
        this.bookCategory = pBookCategory;
        this.ingredient = ingredient;
        this.ingredientAmount = ingredientAmount;
        this.gear = gear;
        this.result = pResult;
        this.smashesRequired = smashesRequired;
        this.serializer = pSerializer;
    }

    public static ForgeRecipeBuilder forging(RecipeCategory pCategory, Ingredient ingredient, int ingredientAmount, Ingredient gear, ItemStack pResult, int smashesRequired) {
        return new ForgeRecipeBuilder(pCategory, ISEBookCategory.FORGE_MISC, ingredient, ingredientAmount, gear, pResult, smashesRequired, (RecipeSerializer<? extends ForgeRecipe>)((RecipeSerializer)Forging.FORGE_RECIPE_SERIALIZER.get()));
    }

    public ForgeRecipeBuilder awardExperience(float experience) {
        this.experience = experience;
        return this;
    }

    public ForgeRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.bookCategory, this.ingredient, this.ingredientAmount, this.gear, this.result, this.smashesRequired, this.experience, this.advancement, pRecipeId.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.serializer));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
        }
    }

    static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ISEBookCategory category;
        private final Ingredient ingredient;
        private final int ingredientAmount;
        private final Ingredient gear;
        private final ItemStack result;
        private final int smashesRequired;
        private final float experience;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<? extends ForgeRecipe> serializer;

        public Result(ResourceLocation id, ISEBookCategory bookCategory, Ingredient ingredient, int ingredientAmount, Ingredient gear, ItemStack pResult, int smashesRequired, float experience, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId, RecipeSerializer<? extends ForgeRecipe> pSerializer) {
            this.id = id;
            this.category = bookCategory;
            this.ingredient = ingredient;
            this.ingredientAmount = ingredientAmount;
            this.gear = gear;
            this.result = pResult;
            this.smashesRequired = smashesRequired;
            this.experience = experience;
            this.serializer = pSerializer;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
        }

        public void m_7917_(JsonObject jObject) {
            jObject.addProperty("category", this.category.m_7912_());
            jObject.add("ingredient", this.ingredient.m_43942_());
            jObject.addProperty("amount", (Number)this.ingredientAmount);
            jObject.add("gear", this.gear.m_43942_());
            if (this.result.m_41783_() != null) {
                JsonObject resultObj = new JsonObject();
                resultObj.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()).toString());
                resultObj.addProperty("nbt", this.result.m_41783_().toString());
                jObject.add("result", (JsonElement)resultObj);
            } else {
                jObject.addProperty("result", ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()).toString());
            }
            jObject.addProperty("smashes_required", (Number)this.smashesRequired);
            if (this.experience > 0.0f) {
                jObject.addProperty("experience", (Number)Float.valueOf(this.experience));
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @javax.annotation.Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @javax.annotation.Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

