/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.multiblockfurnaces.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import insane96mcp.iguanatweaksexpanded.setup.client.ISEBookCategory;
import insane96mcp.iguanatweaksreborn.utils.MCUtils;
import insane96mcp.insanelib.util.MathHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public abstract class AbstractMultiItemSmeltingRecipe
implements Recipe<Container> {
    protected final RecipeType<?> type;
    protected final ResourceLocation id;
    private final ISEBookCategory category;
    protected final String group;
    final NonNullList<Ingredient> ingredients;
    final float experience;
    final float outputIncrease;
    private final ItemStack result;
    protected final int cookingTime;
    @Nullable
    final Recycle recycle;
    private static final RandomSource RANDOM = RandomSource.m_216327_();

    public AbstractMultiItemSmeltingRecipe(RecipeType<?> type, ResourceLocation pId, String pGroup, ISEBookCategory pCategory, int maxIngredients, NonNullList<Ingredient> ingredients, ItemStack pResult, float outputIncrease, float pExperience, int pCookingTime, @Nullable Recycle recycle) {
        this.type = type;
        this.category = pCategory;
        this.id = pId;
        this.group = pGroup;
        this.ingredients = NonNullList.m_122780_((int)maxIngredients, (Object)Ingredient.f_43901_);
        for (int i = 0; i < ingredients.size(); ++i) {
            this.ingredients.set(i, (Object)((Ingredient)ingredients.get(i)));
        }
        this.result = pResult;
        this.outputIncrease = outputIncrease;
        this.experience = pExperience;
        this.cookingTime = pCookingTime;
        this.recycle = recycle;
    }

    public boolean m_5818_(Container container, Level pLevel) {
        ArrayList<Integer> checkedSlots = new ArrayList<Integer>();
        for (Ingredient ingredient : this.ingredients) {
            boolean ingredientMatches = false;
            for (int slot : this.getIngredientSlots()) {
                if (checkedSlots.contains(slot) || !ingredient.test(container.m_8020_(slot))) continue;
                checkedSlots.add(slot);
                ingredientMatches = true;
                break;
            }
            if (ingredientMatches) continue;
            return false;
        }
        return true;
    }

    public boolean hasIngredient(ItemStack stack, Level pLevel) {
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        ItemStack stack = this.result.m_41777_();
        if (this.recycle != null) {
            for (int slot : this.getIngredientSlots()) {
                ItemStack containerStack = container.m_8020_(slot);
                if (containerStack == ItemStack.f_41583_) continue;
                stack.m_41764_(MathHelper.getAmountWithDecimalChance((RandomSource)RANDOM, (float)(MCUtils.getPercentageDurabilityLeft((ItemStack)containerStack) * (float)this.recycle.amountAtFullDurability * this.recycle.ratio)));
                break;
            }
        } else if (this.outputIncrease > 0.0f) {
            int bonusAmount = MathHelper.getAmountWithDecimalChance((RandomSource)RANDOM, (float)this.outputIncrease);
            stack.m_41764_(stack.m_41613_() + bonusAmount);
        }
        return stack;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public int getResultAmount(RegistryAccess registryAccess) {
        if (this.recycle != null) {
            return (int)((float)this.recycle.amountAtFullDurability * this.recycle.ratio);
        }
        if (this.outputIncrease > 0.0f) {
            return (int)(this.outputIncrease + 1.0f);
        }
        return 1;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.addAll(this.ingredients);
        return nonnulllist;
    }

    public RecipeSerializer<?> m_7707_() {
        return null;
    }

    public float getOutputIncrease() {
        return this.outputIncrease;
    }

    public float getExperience() {
        return this.experience;
    }

    public String m_6076_() {
        return this.group;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    @Nullable
    public Recycle getRecycle() {
        return this.recycle;
    }

    public ISEBookCategory category() {
        return this.category;
    }

    abstract int[] getIngredientSlots();

    public boolean m_142505_() {
        NonNullList<Ingredient> nonnulllist = this.m_7527_();
        return nonnulllist.isEmpty() || nonnulllist.stream().anyMatch(AbstractMultiItemSmeltingRecipe::hasNoElements);
    }

    public static boolean hasNoElements(Ingredient ingredient) {
        ItemStack[] items = ingredient.m_43908_();
        if (items.length == 1) {
            MutableComponent hoverName;
            Component component;
            ItemStack item = items[0];
            return item.m_41720_() == Items.f_42127_ && (component = item.m_41786_()) instanceof MutableComponent && (hoverName = (MutableComponent)component).getString().startsWith("Empty Tag: ");
        }
        return false;
    }

    public record Recycle(@SerializedName(value="amount_at_full_durability") int amountAtFullDurability, float ratio) {
        public static Recycle fromJson(JsonObject object) {
            if (!object.has("amount_at_full_durability")) {
                throw new JsonParseException("Too many ingredients for multi item smelting recipe. The maximum is 1 when recycling is present");
            }
            int amountAtFullDurability = object.get("amount_at_full_durability").getAsInt();
            float ratio = 1.0f;
            if (object.has("ratio")) {
                ratio = Mth.m_14036_((float)object.get("ratio").getAsFloat(), (float)0.0f, (float)1.0f);
            }
            return new Recycle(amountAtFullDurability, ratio);
        }

        public JsonElement toJson() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("amount_at_full_durability", (Number)this.amountAtFullDurability);
            if (this.ratio != 1.0f) {
                jsonObject.addProperty("ratio", (Number)Float.valueOf(this.ratio));
            }
            return jsonObject;
        }

        @Nullable
        public static Recycle fromNetwork(FriendlyByteBuf pBuffer) {
            if (pBuffer.readBoolean()) {
                return new Recycle(pBuffer.readInt(), pBuffer.readFloat());
            }
            return null;
        }

        public void toNetwork(FriendlyByteBuf pBuffer) {
            pBuffer.writeInt(this.amountAtFullDurability);
            pBuffer.writeFloat(this.ratio);
        }
    }
}

