/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.multiblockfurnaces.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import insane96mcp.iguanatweaksexpanded.module.mining.multiblockfurnaces.MultiBlockFurnaces;
import insane96mcp.iguanatweaksexpanded.module.mining.multiblockfurnaces.crafting.AbstractMultiItemSmeltingRecipe;
import insane96mcp.iguanatweaksexpanded.setup.client.ISEBookCategory;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MultiItemSmeltingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final ISEBookCategory bookCategory;
    @Nullable
    protected String group;
    final NonNullList<Ingredient> ingredients;
    float experience = 0.0f;
    float outputIncrease = 0.0f;
    private final Item result;
    protected final int cookingTime;
    @Nullable
    AbstractMultiItemSmeltingRecipe.Recycle recycle;
    private final RecipeSerializer<? extends AbstractMultiItemSmeltingRecipe> serializer;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public MultiItemSmeltingRecipeBuilder(RecipeCategory pCategory, ISEBookCategory pBookCategory, ItemLike pResult, NonNullList<Ingredient> pIngredients, int pCookingTime, RecipeSerializer<? extends AbstractMultiItemSmeltingRecipe> pSerializer) {
        this.category = pCategory;
        this.bookCategory = pBookCategory;
        this.result = pResult.m_5456_();
        this.ingredients = pIngredients;
        this.cookingTime = pCookingTime;
        this.serializer = pSerializer;
    }

    public static MultiItemSmeltingRecipeBuilder blasting(NonNullList<Ingredient> pIngredient, RecipeCategory pCategory, ItemLike pResult, int pCookingTime) {
        return new MultiItemSmeltingRecipeBuilder(pCategory, ISEBookCategory.BLAST_FURNACE_MISC, pResult, pIngredient, pCookingTime, (RecipeSerializer<? extends AbstractMultiItemSmeltingRecipe>)((RecipeSerializer)MultiBlockFurnaces.BLASTING_RECIPE_SERIALIZER.get()));
    }

    public static MultiItemSmeltingRecipeBuilder soulBlasting(NonNullList<Ingredient> pIngredient, RecipeCategory pCategory, ItemLike pResult, int pCookingTime) {
        return new MultiItemSmeltingRecipeBuilder(pCategory, ISEBookCategory.SOUL_BLAST_FURNACE_MISC, pResult, pIngredient, pCookingTime, (RecipeSerializer<? extends AbstractMultiItemSmeltingRecipe>)((RecipeSerializer)MultiBlockFurnaces.SOUL_BLASTING_RECIPE_SERIALIZER.get()));
    }

    public MultiItemSmeltingRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public MultiItemSmeltingRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public MultiItemSmeltingRecipeBuilder experience(float experience) {
        this.experience = experience;
        return this;
    }

    public MultiItemSmeltingRecipeBuilder outputIncrease(float outputIncrease) {
        this.outputIncrease = outputIncrease;
        return this;
    }

    public MultiItemSmeltingRecipeBuilder recycle(int amountAtMaxDurability) {
        return this.recycle(amountAtMaxDurability, 1.0f);
    }

    public MultiItemSmeltingRecipeBuilder recycle(int amountAtMaxDurability, float ratio) {
        this.recycle = new AbstractMultiItemSmeltingRecipe.Recycle(amountAtMaxDurability, ratio);
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.group == null ? "" : this.group, this.bookCategory, this.ingredients, this.result, this.experience, this.outputIncrease, this.cookingTime, this.recycle, this.advancement, pRecipeId.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.serializer));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
        }
    }

    static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final ISEBookCategory category;
        private final NonNullList<Ingredient> ingredients;
        private final Item result;
        private final float experience;
        private final float outputIncrease;
        private final int cookingTime;
        @Nullable
        private final AbstractMultiItemSmeltingRecipe.Recycle recycle;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<? extends AbstractMultiItemSmeltingRecipe> serializer;

        public Result(ResourceLocation pId, String pGroup, ISEBookCategory pCategory, NonNullList<Ingredient> pIngredients, Item pResult, float pExperience, float outputIncrease, int pCookingTime, @Nullable AbstractMultiItemSmeltingRecipe.Recycle recycle, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId, RecipeSerializer<? extends AbstractMultiItemSmeltingRecipe> pSerializer) {
            this.id = pId;
            this.group = pGroup;
            this.category = pCategory;
            this.ingredients = pIngredients;
            this.result = pResult;
            this.experience = pExperience;
            this.outputIncrease = outputIncrease;
            this.cookingTime = pCookingTime;
            this.recycle = recycle;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
            this.serializer = pSerializer;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.addProperty("category", this.category.m_7912_());
            JsonArray ingredientsArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                if (ingredient.m_43947_()) continue;
                ingredientsArray.add(ingredient.m_43942_());
            }
            pJson.add("ingredients", (JsonElement)ingredientsArray);
            pJson.addProperty("result", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.experience > 0.0f) {
                pJson.addProperty("experience", (Number)Float.valueOf(this.experience));
            }
            if (this.outputIncrease > 0.0f) {
                pJson.addProperty("output_increase", (Number)Float.valueOf(this.outputIncrease));
            }
            if (this.recycle != null) {
                pJson.add("recycle", this.recycle.toJson());
            }
            pJson.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @javax.annotation.Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @javax.annotation.Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

