/*
 * Decompiled with CFR 0.152.
 */
package com.draconicarcher.brewincompatdelight.events;

import com.draconicarcher.brewincompatdelight.registries.BCDEffectRegistry;
import com.draconicarcher.brewincompatdelight.registries.BCDModEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brewincompatdelight")
public class ArrowLootingHandler {
    private static final String ARROW_LOOTING_LEVEL_KEY = "ArrowLootingLevel";
    private static final String WEAPON_DAMAGE_KEY = "WeaponDamage";
    private static final TagKey<Item> BOWS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/bows"));
    private static final TagKey<Item> CROSSBOWS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/crossbows"));
    private static final TagKey<Item> C_BOWS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("c", "tools/bow"));
    private static final TagKey<Item> C_CROSSBOWS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("c", "tools/crossbow"));

    @SubscribeEvent
    public static void onArrowSpawn(EntityJoinLevelEvent event) {
        Player player;
        AbstractArrow arrow;
        Entity shooter;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow && (shooter = (arrow = (AbstractArrow)entity).m_19749_()) instanceof Player && (player = (Player)shooter).m_21023_((MobEffect)BCDModEffects.ARROW_LOOTING.get())) {
            int effectLevel = player.m_21124_((MobEffect)BCDModEffects.ARROW_LOOTING.get()).m_19564_() + 1;
            arrow.getPersistentData().m_128405_(ARROW_LOOTING_LEVEL_KEY, effectLevel);
            int durabilityLoss = 2 * effectLevel;
            arrow.getPersistentData().m_128405_(WEAPON_DAMAGE_KEY, durabilityLoss);
        }
    }

    @SubscribeEvent
    public static void onLootingLevel(LootingLevelEvent event) {
        AbstractArrow arrow;
        Entity entity;
        if (event.getDamageSource() != null && (entity = event.getDamageSource().m_7640_()) instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).m_19749_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int lootingLevel = arrow.getPersistentData().m_128451_(ARROW_LOOTING_LEVEL_KEY);
            if (lootingLevel > 0) {
                event.setLootingLevel(event.getLootingLevel() + lootingLevel);
                if (arrow.getPersistentData().m_128441_(WEAPON_DAMAGE_KEY)) {
                    int damageAmount = arrow.getPersistentData().m_128451_(WEAPON_DAMAGE_KEY);
                    if (player.m_20194_() != null) {
                        player.m_20194_().execute(() -> BCDEffectRegistry.applyArrowLootingEffect((LivingEntity)player));
                    }
                    arrow.getPersistentData().m_128473_(WEAPON_DAMAGE_KEY);
                }
            }
        }
    }
}

