/*
 * Decompiled with CFR 0.152.
 */
package com.draconicarcher.cocktailsdelight.effects;

import com.draconicarcher.cocktailsdelight.effects.CDModEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(modid="cocktailsdelight", bus=EventBusSubscriber.Bus.GAME)
public class ArrowNBTHandler {
    private static final String ARROW_LOOTING_LEVEL_KEY = "ArrowLootingLevel";

    @SubscribeEvent
    public static void onArrowSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)entity;
        Entity owner = arrow.getOwner();
        if (!(owner instanceof Player)) {
            return;
        }
        Player player = (Player)owner;
        MobEffectInstance lootingEffect = player.getEffect(CDModEffects.ARROW_LOOTING);
        if (lootingEffect == null) {
            return;
        }
        int lootingLevel = lootingEffect.getAmplifier() + 1;
        CompoundTag nbt = arrow.getPersistentData();
        nbt.putInt(ARROW_LOOTING_LEVEL_KEY, lootingLevel);
    }
}

