/*
 * Decompiled with CFR 0.152.
 */
package com.draconicarcher.cocktailsdelight.events;

import com.draconicarcher.cocktailsdelight.effects.CDModEffects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

@EventBusSubscriber
public class ArrowLootingEvent {
    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        Entity projectile = source.getDirectEntity();
        if (!(projectile instanceof Projectile)) {
            return;
        }
        Projectile proj = (Projectile)projectile;
        Entity entity = proj.getOwner();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MobEffectInstance effect = player.getEffect(CDModEffects.ARROW_LOOTING);
        if (effect == null) {
            return;
        }
        int extraRolls = effect.getAmplifier() + 1;
        Level level = target.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        ResourceKey lootKey = target.getType().getDefaultLootTable();
        LootTable table = server.getServer().reloadableRegistries().getLootTable(lootKey);
        LootParams params = new LootParams.Builder(server).withParameter(LootContextParams.THIS_ENTITY, (Object)target).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)target.position()).withLuck(player.getLuck()).create(LootContextParamSets.ENTITY);
        for (int i = 0; i < extraRolls; ++i) {
            table.getRandomItems(params, stack -> {
                if (!stack.isEmpty()) {
                    event.getDrops().add(target.spawnAtLocation(stack.copy()));
                }
            });
        }
    }
}

