/*
 * Decompiled with CFR 0.152.
 */
package com.draconicarcher.cocktailsdelight.events;

import com.draconicarcher.cocktailsdelight.effects.CDModEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class HurricaneEvent {
    @SubscribeEvent
    public static void onLivingHurt(LivingIncomingDamageEvent event) {
        Player player;
        MobEffectInstance effectInstance;
        DamageSource source = event.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof Player && (effectInstance = (player = (Player)entity).getEffect(CDModEffects.HURRICANE)) != null) {
            Level world = player.level();
            int level = effectInstance.getAmplifier() + 1;
            float multiplier = 1.05f + (float)(level - 1) * 0.05f;
            if (world.isThundering()) {
                multiplier = 1.25f + (float)(level - 1) * 0.25f;
            } else if (world.isRaining()) {
                multiplier = 1.1f + (float)(level - 1) * 0.1f;
            }
            float newDamage = event.getAmount() * multiplier;
            event.setAmount(newDamage);
        }
    }
}

