/*
 * Decompiled with CFR 0.152.
 */
package com.draconicarcher.cocktailsdelight.events;

import com.draconicarcher.cocktailsdelight.effects.CDModEffects;
import com.draconicarcher.cocktailsdelight.registries.CDEffectRegistry;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="cocktailsdelight", bus=EventBusSubscriber.Bus.GAME)
public class OverdrawEvent {
    private static final TagKey<Item> C_BOWS_TAG;
    private static final TagKey<Item> C_CROSSBOWS_TAG;

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        ServerPlayer player;
        Optional<MobEffectInstance> effectInstance;
        AbstractArrow arrow;
        Entity shooter;
        Entity entity;
        if (event.getSource() != null && (entity = event.getSource().getDirectEntity()) instanceof AbstractArrow && (shooter = (arrow = (AbstractArrow)entity).getOwner()) instanceof ServerPlayer && (effectInstance = Optional.ofNullable((player = (ServerPlayer)shooter).getEffect(CDModEffects.OVERDRAW))).isPresent()) {
            int effectLevel = effectInstance.get().getAmplifier() + 1;
            float newDamage = event.getNewDamage() * (1.0f + 0.25f * (float)effectLevel);
            event.setNewDamage(newDamage);
        }
    }

    @SubscribeEvent
    public static void onArrowSpawn(EntityJoinLevelEvent event) {
        ServerPlayer player;
        Optional<MobEffectInstance> effect;
        AbstractArrow arrow;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).getOwner()) instanceof ServerPlayer && (effect = Optional.ofNullable((player = (ServerPlayer)entity).getEffect(CDModEffects.OVERDRAW))).isPresent()) {
            int effectLevel = effect.get().getAmplifier() + 1;
            if (player.getServer() != null) {
                player.getServer().execute(() -> CDEffectRegistry.applyOverdrawEffect((LivingEntity)player));
            }
        }
    }

    static {
        ResourceLocation bowsRL = ResourceLocation.tryParse((String)"c:tools/bow");
        if (bowsRL == null) {
            throw new IllegalArgumentException("Invalid ResourceLocation for bows");
        }
        C_BOWS_TAG = ItemTags.create((ResourceLocation)bowsRL);
        ResourceLocation crossbowsRL = ResourceLocation.tryParse((String)"c:tools/crossbow");
        if (crossbowsRL == null) {
            throw new IllegalArgumentException("Invalid ResourceLocation for crossbows");
        }
        C_CROSSBOWS_TAG = ItemTags.create((ResourceLocation)crossbowsRL);
    }
}

