/*
 * Decompiled with CFR 0.152.
 */
package com.draconicarcher.cocktailsdelight.worldgen;

import com.draconicarcher.cocktailsdelight.worldgen.CDConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class CDPlacedFeatures {
    public static final ResourceKey<PlacedFeature> WILD_RED_GRAPES_PLACED_KEY = CDPlacedFeatures.registerKey("wild_red_grapes_placed");
    public static final ResourceKey<PlacedFeature> WILD_WHITE_GRAPES_PLACED_KEY = CDPlacedFeatures.registerKey("wild_white_grapes_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        CDPlacedFeatures.register(context, WILD_RED_GRAPES_PLACED_KEY, configuredFeatures.getOrThrow(CDConfiguredFeatures.WILD_RED_GRAPES_KEY), List.of(RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        CDPlacedFeatures.register(context, WILD_WHITE_GRAPES_PLACED_KEY, configuredFeatures.getOrThrow(CDConfiguredFeatures.WILD_WHITE_GRAPES_KEY), List.of(RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cocktailsdelight", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

