/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessbackrooms.block;

import net.mcreator.endlessbackrooms.procedures.TheTormentStatueGlobalProcedureProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ARGB;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TheTormentStatueBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public TheTormentStatueBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.SOUL_SOIL).strength(-1.0f, 3600000.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public Integer getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        return ARGB.opaque((int)-10066330);
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)TheTormentStatueBlock.box((double)4.0, (double)24.0, (double)4.0, (double)12.0, (double)32.0, (double)12.0), (VoxelShape[])new VoxelShape[]{TheTormentStatueBlock.box((double)4.0, (double)12.0, (double)6.0, (double)12.0, (double)24.0, (double)10.0), TheTormentStatueBlock.box((double)0.0, (double)12.0, (double)6.0, (double)4.0, (double)24.0, (double)10.0), TheTormentStatueBlock.box((double)12.0, (double)12.0, (double)6.0, (double)16.0, (double)24.0, (double)10.0), TheTormentStatueBlock.box((double)4.1, (double)0.0, (double)6.0, (double)8.1, (double)12.0, (double)10.0), TheTormentStatueBlock.box((double)7.9, (double)0.0, (double)6.0, (double)11.9, (double)12.0, (double)10.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)TheTormentStatueBlock.box((double)4.0, (double)24.0, (double)4.0, (double)12.0, (double)32.0, (double)12.0), (VoxelShape[])new VoxelShape[]{TheTormentStatueBlock.box((double)4.0, (double)12.0, (double)6.0, (double)12.0, (double)24.0, (double)10.0), TheTormentStatueBlock.box((double)12.0, (double)12.0, (double)6.0, (double)16.0, (double)24.0, (double)10.0), TheTormentStatueBlock.box((double)0.0, (double)12.0, (double)6.0, (double)4.0, (double)24.0, (double)10.0), TheTormentStatueBlock.box((double)7.9, (double)0.0, (double)6.0, (double)11.9, (double)12.0, (double)10.0), TheTormentStatueBlock.box((double)4.1, (double)0.0, (double)6.0, (double)8.1, (double)12.0, (double)10.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)TheTormentStatueBlock.box((double)4.0, (double)24.0, (double)4.0, (double)12.0, (double)32.0, (double)12.0), (VoxelShape[])new VoxelShape[]{TheTormentStatueBlock.box((double)6.0, (double)12.0, (double)4.0, (double)10.0, (double)24.0, (double)12.0), TheTormentStatueBlock.box((double)6.0, (double)12.0, (double)12.0, (double)10.0, (double)24.0, (double)16.0), TheTormentStatueBlock.box((double)6.0, (double)12.0, (double)0.0, (double)10.0, (double)24.0, (double)4.0), TheTormentStatueBlock.box((double)6.0, (double)0.0, (double)7.9, (double)10.0, (double)12.0, (double)11.9), TheTormentStatueBlock.box((double)6.0, (double)0.0, (double)4.1, (double)10.0, (double)12.0, (double)8.1)});
            case Direction.WEST -> Shapes.or((VoxelShape)TheTormentStatueBlock.box((double)4.0, (double)24.0, (double)4.0, (double)12.0, (double)32.0, (double)12.0), (VoxelShape[])new VoxelShape[]{TheTormentStatueBlock.box((double)6.0, (double)12.0, (double)4.0, (double)10.0, (double)24.0, (double)12.0), TheTormentStatueBlock.box((double)6.0, (double)12.0, (double)0.0, (double)10.0, (double)24.0, (double)4.0), TheTormentStatueBlock.box((double)6.0, (double)12.0, (double)12.0, (double)10.0, (double)24.0, (double)16.0), TheTormentStatueBlock.box((double)6.0, (double)0.0, (double)4.1, (double)10.0, (double)12.0, (double)8.1), TheTormentStatueBlock.box((double)6.0, (double)0.0, (double)7.9, (double)10.0, (double)12.0, (double)11.9)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public void attack(BlockState blockstate, Level world, BlockPos pos, Player entity) {
        super.attack(blockstate, world, pos, entity);
        TheTormentStatueGlobalProcedureProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity);
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity, InsideBlockEffectApplier applier) {
        super.entityInside(blockstate, world, pos, entity, applier);
        TheTormentStatueGlobalProcedureProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), entity);
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.stepOn(world, pos, blockstate, entity);
        TheTormentStatueGlobalProcedureProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), entity);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        TheTormentStatueGlobalProcedureProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }
}

