/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Support;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class AddConvexRadiusSupport
extends JoltPhysicsObject {
    public AddConvexRadiusSupport(Support support, float convexRadius) {
        long supportVa = support.va();
        long addVa = AddConvexRadiusSupport.createAdd(supportVa, convexRadius);
        this.setVirtualAddress(addVa, () -> AddConvexRadiusSupport.free(addVa));
    }

    public Vec3 getSupport(Vec3Arg direction) {
        long addVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        float[] storeFloats = new float[3];
        AddConvexRadiusSupport.getSupport(addVa, dx, dy, dz, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    private static native long createAdd(long var0, float var2);

    private static native void free(long var0);

    private static native void getSupport(long var0, float var2, float var3, float var4, float[] var5);
}

