/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CharacterVirtual;
import com.github.stephengold.joltjni.CharacterVirtualRef;
import com.github.stephengold.joltjni.CharacterVsCharacterCollision;
import com.github.stephengold.joltjni.readonly.ConstCharacterVirtual;
import java.util.ArrayList;
import java.util.List;

public class CharacterVsCharacterCollisionSimple
extends CharacterVsCharacterCollision {
    private final List<CharacterVirtualRef> collisionList = new ArrayList<CharacterVirtualRef>(16);

    public CharacterVsCharacterCollisionSimple() {
        long interfaceVa = CharacterVsCharacterCollisionSimple.createDefault();
        this.setVirtualAddressAsOwner(interfaceVa);
    }

    public void add(CharacterVirtual character) {
        long interfaceVa = this.va();
        long characterVa = character.targetVa();
        CharacterVsCharacterCollisionSimple.add(interfaceVa, characterVa);
        this.collisionList.add(character.toRef());
    }

    public CharacterVirtual[] getCharacters() {
        int numCharacters = this.collisionList.size();
        CharacterVirtual[] result = new CharacterVirtual[numCharacters];
        for (int i = 0; i < numCharacters; ++i) {
            result[i] = this.collisionList.get(i).getPtr();
        }
        return result;
    }

    public void remove(ConstCharacterVirtual characterRef) {
        long interfaceVa = this.va();
        long characterVa = characterRef.targetVa();
        CharacterVsCharacterCollisionSimple.remove(interfaceVa, characterVa);
        int numCharacters = this.collisionList.size();
        for (int i = 0; i < numCharacters; ++i) {
            long tmpVa = this.collisionList.get(i).targetVa();
            if (tmpVa != characterVa) continue;
            this.collisionList.remove(i);
            break;
        }
    }

    private static native void add(long var0, long var2);

    private static native long createDefault();

    private static native void remove(long var0, long var2);
}

