/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.readonly.ConstEdge;

public class Edge
extends JoltPhysicsObject
implements ConstEdge {
    public Edge() {
        long edgeVa = Edge.createDefault();
        this.setVirtualAddress(edgeVa, () -> Edge.free(edgeVa));
    }

    Edge(JoltPhysicsObject container, long edgeVa) {
        super(container, edgeVa);
    }

    public Edge setCompliance(float compliance) {
        long edgeVa = this.va();
        Edge.setCompliance(edgeVa, compliance);
        return this;
    }

    public Edge setRestLength(float length) {
        long edgeVa = this.va();
        Edge.setRestLength(edgeVa, length);
        return this;
    }

    public Edge setVertex(int indexInEdge, int indexInMesh) {
        long edgeVa = this.va();
        Edge.setVertex(edgeVa, indexInEdge, indexInMesh);
        return this;
    }

    @Override
    public float getCompliance() {
        long edgeVa = this.va();
        float result = Edge.getCompliance(edgeVa);
        return result;
    }

    @Override
    public float getRestLength() {
        long edgeVa = this.va();
        float result = Edge.getRestLength(edgeVa);
        return result;
    }

    @Override
    public int getVertex(int indexInEdge) {
        long edgeVa = this.va();
        int result = Edge.getVertex(edgeVa, indexInEdge);
        return result;
    }

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getCompliance(long var0);

    private static native float getRestLength(long var0);

    private static native int getVertex(long var0, int var2);

    private static native void setCompliance(long var0, float var2);

    private static native void setRestLength(long var0, float var2);

    private static native void setVertex(long var0, int var2, int var3);
}

