/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.TempAllocator;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class HeightFieldShape
extends Shape {
    HeightFieldShape(long shapeVa) {
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    public int getBlockSize() {
        long shapeVa = this.va();
        int result = HeightFieldShape.getBlockSize(shapeVa);
        return result;
    }

    public Vec3 getPosition(int x, int y) {
        long shapeVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        HeightFieldShape.getPosition(shapeVa, x, y, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getSurfaceNormal(int subShapeId, Vec3Arg localLocation) {
        long shapeVa = this.va();
        float x = localLocation.getX();
        float y = localLocation.getY();
        float z = localLocation.getZ();
        float[] storeFloats = new float[3];
        HeightFieldShape.getSurfaceNormal(shapeVa, subShapeId, x, y, z, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public boolean isNoCollision(int x, int y) {
        long shapeVa = this.va();
        boolean result = HeightFieldShape.isNoCollision(shapeVa, x, y);
        return result;
    }

    public boolean projectOntoSurface(Vec3Arg localLocation, Vec3 storeSurfaceLocation, int[] storeSubShapeId) {
        long shapeVa = this.va();
        float x = localLocation.getX();
        float y = localLocation.getY();
        float z = localLocation.getZ();
        float[] storeFloats = new float[3];
        boolean result = HeightFieldShape.projectOntoSurface(shapeVa, x, y, z, storeFloats, storeSubShapeId);
        storeSurfaceLocation.set(storeFloats);
        return result;
    }

    public void setHeights(int startX, int startY, int sizeX, int sizeY, FloatBuffer heights, int stride, TempAllocator allocator) {
        this.setHeights(startX, startY, sizeX, sizeY, heights, stride, allocator, 0.996195f);
    }

    public void setHeights(int startX, int startY, int sizeX, int sizeY, FloatBuffer heights, int stride, TempAllocator allocator, float cosThresholdAngle) {
        long shapeVa = this.va();
        long allocatorVa = allocator.va();
        HeightFieldShape.setHeights(shapeVa, startX, startY, sizeX, sizeY, heights, stride, allocatorVa, cosThresholdAngle);
    }

    private static native int getBlockSize(long var0);

    private static native void getPosition(long var0, int var2, int var3, FloatBuffer var4);

    private static native void getSurfaceNormal(long var0, int var2, float var3, float var4, float var5, float[] var6);

    private static native boolean isNoCollision(long var0, int var2, int var3);

    private static native boolean projectOntoSurface(long var0, float var2, float var3, float var4, float[] var5, int[] var6);

    private static native void setHeights(long var0, int var2, int var3, int var4, int var5, FloatBuffer var6, int var7, long var8, float var10);
}

