/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class JointState
extends JoltPhysicsObject {
    JointState(JoltPhysicsObject container, long stateVa) {
        super(container, stateVa);
    }

    public Quat getRotation() {
        long stateVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        JointState.getRotation(stateVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    public Vec3 getTranslation() {
        long stateVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        JointState.getTranslation(stateVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public void setRotation(QuatArg rotation) {
        long stateVa = this.va();
        float qw = rotation.getW();
        float qx = rotation.getX();
        float qy = rotation.getY();
        float qz = rotation.getZ();
        JointState.setRotation(stateVa, qx, qy, qz, qw);
    }

    public void setTranslation(Vec3Arg offset) {
        long stateVa = this.va();
        float x = offset.getX();
        float y = offset.getY();
        float z = offset.getZ();
        JointState.setTranslation(stateVa, x, y, z);
    }

    private static native void getRotation(long var0, FloatBuffer var2);

    private static native void getTranslation(long var0, FloatBuffer var2);

    private static native void setRotation(long var0, float var2, float var3, float var4, float var5);

    private static native void setTranslation(long var0, float var2, float var3, float var4);
}

