/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.ConstraintSettingsRef;
import com.github.stephengold.joltjni.GroupFilterTableRef;
import com.github.stephengold.joltjni.PhysicsMaterialRef;
import com.github.stephengold.joltjni.PhysicsSceneRef;
import com.github.stephengold.joltjni.RagdollSettingsRef;
import com.github.stephengold.joltjni.ShapeSettingsRef;
import com.github.stephengold.joltjni.SkeletalAnimationRef;
import com.github.stephengold.joltjni.SkeletonRef;
import com.github.stephengold.joltjni.SoftBodyCreationSettings;
import com.github.stephengold.joltjni.SoftBodySharedSettingsRef;
import com.github.stephengold.joltjni.TwoBodyConstraintSettingsRef;
import com.github.stephengold.joltjni.VehicleConstraintSettingsRef;
import com.github.stephengold.joltjni.VehicleControllerSettingsRef;
import com.github.stephengold.joltjni.std.StringStream;
import com.github.stephengold.joltjni.template.Ref;

public final class ObjectStreamIn {
    private ObjectStreamIn() {
    }

    public static boolean sReadObject(String fileName, Ref storeRef) {
        boolean result;
        long refVa = storeRef.va();
        if (storeRef instanceof PhysicsSceneRef) {
            result = ObjectStreamIn.sReadPhysicsScene(fileName, refVa);
        } else if (storeRef instanceof RagdollSettingsRef) {
            result = ObjectStreamIn.sReadRagdollSettings(fileName, refVa);
        } else if (storeRef instanceof SkeletalAnimationRef) {
            result = ObjectStreamIn.sReadSkeletalAnimation(fileName, refVa);
        } else if (storeRef instanceof SkeletonRef) {
            result = ObjectStreamIn.sReadSkeleton(fileName, refVa);
        } else {
            throw new IllegalArgumentException(storeRef.getClass().getSimpleName());
        }
        return result;
    }

    public static boolean sReadObject(StringStream stream, BodyCreationSettings[] storeBcs) {
        long streamVa = stream.va();
        long[] storeVa = new long[]{0L};
        boolean result = ObjectStreamIn.sReadBcsFromStream(streamVa, storeVa);
        long bodySettingsVa = storeVa[0];
        storeBcs[0] = new BodyCreationSettings(bodySettingsVa, true);
        return result;
    }

    public static boolean sReadObject(StringStream stream, ConstraintSettingsRef settingsRef) {
        long streamVa = stream.va();
        long settingsRefVa = settingsRef.va();
        boolean result = ObjectStreamIn.sReadConstraintSettingsFromStream(streamVa, settingsRefVa);
        return result;
    }

    public static boolean sReadObject(StringStream stream, GroupFilterTableRef filterRef) {
        long streamVa = stream.va();
        long refVa = filterRef.va();
        boolean result = ObjectStreamIn.sReadGroupFilterTableFromStream(streamVa, refVa);
        return result;
    }

    public static boolean sReadObject(StringStream stream, PhysicsMaterialRef materialRef) {
        long streamVa = stream.va();
        long refVa = materialRef.va();
        boolean result = ObjectStreamIn.sReadPhysicsMaterialFromStream(streamVa, refVa);
        return result;
    }

    public static boolean sReadObject(StringStream stream, PhysicsSceneRef sceneRef) {
        long streamVa = stream.va();
        long refVa = sceneRef.va();
        boolean result = ObjectStreamIn.sReadPhysicsSceneFromStream(streamVa, refVa);
        return result;
    }

    public static boolean sReadObject(StringStream stream, RagdollSettingsRef settingsRef) {
        long streamVa = stream.va();
        long refVa = settingsRef.va();
        boolean result = ObjectStreamIn.sReadRagdollSettingsFromStream(streamVa, refVa);
        return result;
    }

    public static boolean sReadObject(StringStream stream, ShapeSettingsRef settingsRef) {
        long streamVa = stream.va();
        long refVa = settingsRef.va();
        boolean result = ObjectStreamIn.sReadShapeSettingsFromStream(streamVa, refVa);
        return result;
    }

    public static boolean sReadObject(StringStream stream, SoftBodyCreationSettings[] storeSbcs) {
        long streamVa = stream.va();
        long[] storeVa = new long[]{0L};
        boolean result = ObjectStreamIn.sReadSbcsFromStream(streamVa, storeVa);
        long bodySettingsVa = storeVa[0];
        storeSbcs[0] = new SoftBodyCreationSettings(bodySettingsVa, true);
        return result;
    }

    public static boolean sReadObject(StringStream stream, SoftBodySharedSettingsRef settingsRef) {
        long streamVa = stream.va();
        long refVa = settingsRef.va();
        boolean result = ObjectStreamIn.sReadSbssFromStream(streamVa, refVa);
        return result;
    }

    public static boolean sReadObject(StringStream stream, TwoBodyConstraintSettingsRef settingsRef) {
        long streamVa = stream.va();
        long refVa = settingsRef.va();
        boolean result = ObjectStreamIn.sReadConstraintSettingsFromStream(streamVa, refVa);
        return result;
    }

    public static boolean sReadObject(StringStream stream, VehicleConstraintSettingsRef settingsRef) {
        long streamVa = stream.va();
        long refVa = settingsRef.va();
        boolean result = ObjectStreamIn.sReadConstraintSettingsFromStream(streamVa, refVa);
        return result;
    }

    public static boolean sReadObject(StringStream stream, VehicleControllerSettingsRef settingsRef) {
        long streamVa = stream.va();
        long refVa = settingsRef.va();
        boolean result = ObjectStreamIn.sReadControllerSettingsFromStream(streamVa, refVa);
        return result;
    }

    private static native boolean sReadBcsFromStream(long var0, long[] var2);

    private static native boolean sReadConstraintSettingsFromStream(long var0, long var2);

    private static native boolean sReadControllerSettingsFromStream(long var0, long var2);

    private static native boolean sReadGroupFilterTableFromStream(long var0, long var2);

    private static native boolean sReadPhysicsMaterialFromStream(long var0, long var2);

    private static native boolean sReadPhysicsScene(String var0, long var1);

    private static native boolean sReadPhysicsSceneFromStream(long var0, long var2);

    private static native boolean sReadRagdollSettings(String var0, long var1);

    private static native boolean sReadRagdollSettingsFromStream(long var0, long var2);

    private static native boolean sReadSbcsFromStream(long var0, long[] var2);

    private static native boolean sReadSbssFromStream(long var0, long var2);

    private static native boolean sReadShapeSettingsFromStream(long var0, long var2);

    private static native boolean sReadSkeletalAnimation(String var0, long var1);

    private static native boolean sReadSkeleton(String var0, long var1);
}

