/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.PhysicsMaterialSimple;
import com.github.stephengold.joltjni.template.Ref;

public final class PhysicsMaterialRef
extends Ref {
    public PhysicsMaterialRef() {
        long refVa = PhysicsMaterialRef.createDefault();
        this.setVirtualAddress(refVa, () -> PhysicsMaterialRef.free(refVa));
    }

    PhysicsMaterialRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> PhysicsMaterialRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public PhysicsMaterialSimple getPtrAsSimple() {
        long materialVa = this.targetVa();
        PhysicsMaterialSimple result = new PhysicsMaterialSimple(materialVa);
        return result;
    }

    @Override
    public PhysicsMaterial getPtr() {
        long materialVa = this.targetVa();
        PhysicsMaterial result = new PhysicsMaterial(materialVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = PhysicsMaterialRef.getPtr(refVa);
        return result;
    }

    @Override
    public PhysicsMaterialRef toRef() {
        long refVa = this.va();
        long copyVa = PhysicsMaterialRef.copy(refVa);
        PhysicsMaterialRef result = new PhysicsMaterialRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

