/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BoxShapeSettings;
import com.github.stephengold.joltjni.CapsuleShapeSettings;
import com.github.stephengold.joltjni.ConvexHullShapeSettings;
import com.github.stephengold.joltjni.CylinderShapeSettings;
import com.github.stephengold.joltjni.EmptyShapeSettings;
import com.github.stephengold.joltjni.HeightFieldShapeSettings;
import com.github.stephengold.joltjni.MeshShapeSettings;
import com.github.stephengold.joltjni.MutableCompoundShapeSettings;
import com.github.stephengold.joltjni.OffsetCenterOfMassShapeSettings;
import com.github.stephengold.joltjni.PlaneShapeSettings;
import com.github.stephengold.joltjni.RotatedTranslatedShapeSettings;
import com.github.stephengold.joltjni.ScaledShapeSettings;
import com.github.stephengold.joltjni.SerializableObject;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.ShapeSettingsRef;
import com.github.stephengold.joltjni.ShapeSettingsRefC;
import com.github.stephengold.joltjni.SphereShapeSettings;
import com.github.stephengold.joltjni.StaticCompoundShapeSettings;
import com.github.stephengold.joltjni.TaperedCapsuleShapeSettings;
import com.github.stephengold.joltjni.TaperedCylinderShapeSettings;
import com.github.stephengold.joltjni.TriangleShapeSettings;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.ConstShapeSettings;

public abstract class ShapeSettings
extends SerializableObject
implements ConstShapeSettings {
    ShapeSettings() {
    }

    public void clearCachedResult() {
        long settingsVa = this.va();
        ShapeSettings.clearCachedResult(settingsVa);
    }

    public static ShapeSettings cloneShapeSettings(ConstShapeSettings original) {
        ShapeSettings result;
        long originalVa = original.targetVa();
        long ordinal = ShapeSettings.getUserData(originalVa);
        EShapeSubType subType = EShapeSubType.values()[(int)ordinal];
        switch (subType) {
            case Box: {
                result = new BoxShapeSettings((BoxShapeSettings)original);
                break;
            }
            case Capsule: {
                result = new CapsuleShapeSettings((CapsuleShapeSettings)original);
                break;
            }
            case ConvexHull: {
                result = new ConvexHullShapeSettings((ConvexHullShapeSettings)original);
                break;
            }
            case Cylinder: {
                result = new CylinderShapeSettings((CylinderShapeSettings)original);
                break;
            }
            case Empty: {
                result = new EmptyShapeSettings((EmptyShapeSettings)original);
                break;
            }
            case HeightField: {
                result = new HeightFieldShapeSettings((HeightFieldShapeSettings)original);
                break;
            }
            case Mesh: {
                result = new MeshShapeSettings((MeshShapeSettings)original);
                break;
            }
            case MutableCompound: {
                result = new MutableCompoundShapeSettings((MutableCompoundShapeSettings)original);
                break;
            }
            case OffsetCenterOfMass: {
                result = new OffsetCenterOfMassShapeSettings((OffsetCenterOfMassShapeSettings)original);
                break;
            }
            case Plane: {
                result = new PlaneShapeSettings((PlaneShapeSettings)original);
                break;
            }
            case RotatedTranslated: {
                result = new RotatedTranslatedShapeSettings((RotatedTranslatedShapeSettings)original);
                break;
            }
            case Scaled: {
                result = new ScaledShapeSettings((ScaledShapeSettings)original);
                break;
            }
            case Sphere: {
                result = new SphereShapeSettings((SphereShapeSettings)original);
                break;
            }
            case StaticCompound: {
                result = new StaticCompoundShapeSettings((StaticCompoundShapeSettings)original);
                break;
            }
            case TaperedCapsule: {
                result = new TaperedCapsuleShapeSettings((TaperedCapsuleShapeSettings)original);
                break;
            }
            case TaperedCylinder: {
                result = new TaperedCylinderShapeSettings((TaperedCylinderShapeSettings)original);
                break;
            }
            case Triangle: {
                result = new TriangleShapeSettings((TriangleShapeSettings)original);
                break;
            }
            default: {
                throw new IllegalArgumentException("subType = " + String.valueOf((Object)subType));
            }
        }
        return result;
    }

    static ShapeSettings newShapeSettings(long settingsVa) {
        ShapeSettings result;
        if (settingsVa == 0L) {
            return null;
        }
        long ordinal = ShapeSettings.getUserData(settingsVa);
        EShapeSubType subType = EShapeSubType.values()[(int)ordinal];
        switch (subType) {
            case Box: {
                result = new BoxShapeSettings(settingsVa);
                break;
            }
            case Capsule: {
                result = new CapsuleShapeSettings(settingsVa);
                break;
            }
            case ConvexHull: {
                result = new ConvexHullShapeSettings(settingsVa);
                break;
            }
            case Cylinder: {
                result = new CylinderShapeSettings(settingsVa);
                break;
            }
            case Empty: {
                result = new EmptyShapeSettings(settingsVa);
                break;
            }
            case HeightField: {
                result = new HeightFieldShapeSettings(settingsVa);
                break;
            }
            case Mesh: {
                result = new MeshShapeSettings(settingsVa);
                break;
            }
            case MutableCompound: {
                result = new MutableCompoundShapeSettings(settingsVa);
                break;
            }
            case OffsetCenterOfMass: {
                result = new OffsetCenterOfMassShapeSettings(settingsVa);
                break;
            }
            case Plane: {
                result = new PlaneShapeSettings(settingsVa);
                break;
            }
            case RotatedTranslated: {
                result = new RotatedTranslatedShapeSettings(settingsVa);
                break;
            }
            case Scaled: {
                result = new ScaledShapeSettings(settingsVa);
                break;
            }
            case Sphere: {
                result = new SphereShapeSettings(settingsVa);
                break;
            }
            case StaticCompound: {
                result = new StaticCompoundShapeSettings(settingsVa);
                break;
            }
            case TaperedCapsule: {
                result = new TaperedCapsuleShapeSettings(settingsVa);
                break;
            }
            case TaperedCylinder: {
                result = new TaperedCylinderShapeSettings(settingsVa);
                break;
            }
            case Triangle: {
                result = new TriangleShapeSettings(settingsVa);
                break;
            }
            default: {
                throw new IllegalArgumentException("subType = " + String.valueOf((Object)subType));
            }
        }
        return result;
    }

    protected final void setVirtualAddressAsCoOwner(long settingsVa, EShapeSubType shapeSubType) {
        long refVa = ShapeSettings.toRef(settingsVa);
        Runnable freeingAction = () -> ShapeSettingsRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
        long ordinal = shapeSubType.ordinal();
        ShapeSettings.setUserData(settingsVa, ordinal);
    }

    @Override
    public ShapeResult create() {
        long settingsVa = this.va();
        long resultVa = ShapeSettings.create(settingsVa);
        ShapeResult result = new ShapeResult(resultVa, true);
        return result;
    }

    @Override
    public ShapeSettingsRefC toRefC() {
        long settingsVa = this.va();
        long refVa = ShapeSettings.toRefC(settingsVa);
        ShapeSettingsRefC result = new ShapeSettingsRefC(refVa, true);
        return result;
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.va();
        int result = ShapeSettings.getRefCount(settingsVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long settingsVa = this.va();
        ShapeSettings.setEmbedded(settingsVa);
    }

    @Override
    public ShapeSettingsRef toRef() {
        long settingsVa = this.va();
        long refVa = ShapeSettings.toRef(settingsVa);
        ShapeSettingsRef result = new ShapeSettingsRef(refVa, true);
        return result;
    }

    private static native void clearCachedResult(long var0);

    static native long create(long var0);

    static native int getRefCount(long var0);

    private static native long getUserData(long var0);

    private static native void setEmbedded(long var0);

    private static native void setUserData(long var0, long var2);

    private static native long toRef(long var0);

    private static native long toRefC(long var0);
}

