/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CollisionGroup;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.SbcsResult;
import com.github.stephengold.joltjni.SoftBodySharedSettings;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.readonly.ConstCollisionGroup;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyCreationSettings;
import com.github.stephengold.joltjni.readonly.ConstSoftBodySharedSettings;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.streamutils.GroupFilterToIdMap;
import com.github.stephengold.joltjni.streamutils.IdToGroupFilterMap;
import com.github.stephengold.joltjni.streamutils.IdToMaterialMap;
import com.github.stephengold.joltjni.streamutils.IdToSharedSettingsMap;
import com.github.stephengold.joltjni.streamutils.MaterialToIdMap;
import com.github.stephengold.joltjni.streamutils.SharedSettingsToIdMap;

public class SoftBodyCreationSettings
extends JoltPhysicsObject
implements ConstSoftBodyCreationSettings {
    public SoftBodyCreationSettings() {
        long bodySettingsVa = SoftBodyCreationSettings.createDefault();
        this.setVirtualAddress(bodySettingsVa, () -> SoftBodyCreationSettings.free(bodySettingsVa));
    }

    public SoftBodyCreationSettings(ConstSoftBodyCreationSettings original) {
        long originalVa = original.targetVa();
        long copyVa = SoftBodyCreationSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> SoftBodyCreationSettings.free(copyVa));
    }

    public SoftBodyCreationSettings(ConstSoftBodySharedSettings settings, RVec3Arg location, QuatArg orientation, int objectLayer) {
        long sharedSettingsVa = settings.targetVa();
        double xx = location.xx();
        double yy = location.yy();
        double zz = location.zz();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        long bodySettingsVa = SoftBodyCreationSettings.createFromSharedSettings(sharedSettingsVa, xx, yy, zz, qx, qy, qz, qw, objectLayer);
        this.setVirtualAddress(bodySettingsVa, () -> SoftBodyCreationSettings.free(bodySettingsVa));
    }

    SoftBodyCreationSettings(JoltPhysicsObject container, long bodySettingsVa) {
        super(container, bodySettingsVa);
    }

    SoftBodyCreationSettings(long bodySettingsVa, boolean owner) {
        Runnable freeingAction = owner ? () -> SoftBodyCreationSettings.free(bodySettingsVa) : null;
        this.setVirtualAddress(bodySettingsVa, freeingAction);
    }

    public void restoreBinaryState(StreamIn stream) {
        long bodySettingsVa = this.va();
        long streamVa = stream.va();
        SoftBodyCreationSettings.restoreBinaryState(bodySettingsVa, streamVa);
    }

    public SoftBodyCreationSettings setAllowSleeping(boolean allow) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setAllowSleeping(bodySettingsVa, allow);
        return this;
    }

    public SoftBodyCreationSettings setCollisionGroup(ConstCollisionGroup group) {
        long bodySettingsVa = this.va();
        long groupVa = group.targetVa();
        SoftBodyCreationSettings.setCollisionGroup(bodySettingsVa, groupVa);
        return this;
    }

    public SoftBodyCreationSettings setFacesDoubleSided(boolean enable) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setFacesDoubleSided(bodySettingsVa, enable);
        return this;
    }

    public SoftBodyCreationSettings setFriction(float friction) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setFriction(bodySettingsVa, friction);
        return this;
    }

    public SoftBodyCreationSettings setGravityFactor(float factor) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setGravityFactor(bodySettingsVa, factor);
        return this;
    }

    public SoftBodyCreationSettings setLinearDamping(float damping) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setLinearDamping(bodySettingsVa, damping);
        return this;
    }

    public SoftBodyCreationSettings setMakeRotationIdentity(boolean enable) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setMakeRotationIdentity(bodySettingsVa, enable);
        return this;
    }

    public SoftBodyCreationSettings setMaxLinearVelocity(float maxSpeed) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setMaxLinearVelocity(bodySettingsVa, maxSpeed);
        return this;
    }

    public SoftBodyCreationSettings setNumIterations(int numIterations) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setNumIterations(bodySettingsVa, numIterations);
        return this;
    }

    public SoftBodyCreationSettings setObjectLayer(int objLayer) {
        assert (objLayer >= 0 && objLayer < 65536) : "objLayer = " + objLayer;
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setObjectLayer(bodySettingsVa, objLayer);
        return this;
    }

    public SoftBodyCreationSettings setPosition(double xx, double yy, double zz) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setPosition(bodySettingsVa, xx, yy, zz);
        return this;
    }

    public SoftBodyCreationSettings setPosition(RVec3Arg location) {
        long bodySettingsVa = this.va();
        double xx = location.xx();
        double yy = location.yy();
        double zz = location.zz();
        SoftBodyCreationSettings.setPosition(bodySettingsVa, xx, yy, zz);
        return this;
    }

    public SoftBodyCreationSettings setPressure(float pressure) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setPressure(bodySettingsVa, pressure);
        return this;
    }

    public SoftBodyCreationSettings setRestitution(float restitution) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setRestitution(bodySettingsVa, restitution);
        return this;
    }

    public SoftBodyCreationSettings setRotation(QuatArg orientation) {
        long bodySettingsVa = this.va();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        SoftBodyCreationSettings.setRotation(bodySettingsVa, qx, qy, qz, qw);
        return this;
    }

    public SoftBodyCreationSettings setSettings(ConstSoftBodySharedSettings sharedSettings) {
        long bodySettingsVa = this.va();
        long sharedSettingsVa = sharedSettings.targetVa();
        SoftBodyCreationSettings.setSettings(bodySettingsVa, sharedSettingsVa);
        return this;
    }

    public SoftBodyCreationSettings setUpdatePosition(boolean enable) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setUpdatePosition(bodySettingsVa, enable);
        return this;
    }

    public SoftBodyCreationSettings setUserData(long value) {
        long bodySettingsVa = this.va();
        SoftBodyCreationSettings.setUserData(bodySettingsVa, value);
        return this;
    }

    public SoftBodyCreationSettings setVertexRadius(float radius) {
        long settingsVa = this.va();
        SoftBodyCreationSettings.setVertexRadius(settingsVa, radius);
        return this;
    }

    public static SbcsResult sRestoreWithChildren(StreamIn stream, IdToSharedSettingsMap settingsMap, IdToMaterialMap materialMap, IdToGroupFilterMap filterMap) {
        long streamVa = stream.va();
        long settingsMapVa = settingsMap.va();
        long materialMapVa = materialMap.va();
        long filterMapVa = filterMap.va();
        long resultVa = SoftBodyCreationSettings.sRestoreWithChildren(streamVa, settingsMapVa, materialMapVa, filterMapVa);
        SbcsResult result = new SbcsResult(resultVa, true);
        return result;
    }

    @Override
    public boolean getAllowSleeping() {
        long bodySettingsVa = this.va();
        boolean result = SoftBodyCreationSettings.getAllowSleeping(bodySettingsVa);
        return result;
    }

    @Override
    public CollisionGroup getCollisionGroup() {
        long bodySettingsVa = this.va();
        long resultVa = SoftBodyCreationSettings.getCollisionGroup(bodySettingsVa);
        CollisionGroup result = new CollisionGroup(this, resultVa);
        return result;
    }

    @Override
    public boolean getFacesDoubleSided() {
        long bodySettingsVa = this.va();
        boolean result = SoftBodyCreationSettings.getFacesDoubleSided(bodySettingsVa);
        return result;
    }

    @Override
    public float getFriction() {
        long bodySettingsVa = this.va();
        float result = SoftBodyCreationSettings.getFriction(bodySettingsVa);
        return result;
    }

    @Override
    public float getGravityFactor() {
        long bodySettingsVa = this.va();
        float result = SoftBodyCreationSettings.getGravityFactor(bodySettingsVa);
        return result;
    }

    @Override
    public float getLinearDamping() {
        long bodySettingsVa = this.va();
        float result = SoftBodyCreationSettings.getLinearDamping(bodySettingsVa);
        return result;
    }

    @Override
    public boolean getMakeRotationIdentity() {
        long bodySettingsVa = this.va();
        boolean result = SoftBodyCreationSettings.getMakeRotationIdentity(bodySettingsVa);
        return result;
    }

    @Override
    public float getMaxLinearVelocity() {
        long bodySettingsVa = this.va();
        float result = SoftBodyCreationSettings.getMaxLinearVelocity(bodySettingsVa);
        return result;
    }

    @Override
    public int getNumIterations() {
        long bodySettingsVa = this.va();
        int result = SoftBodyCreationSettings.getNumIterations(bodySettingsVa);
        return result;
    }

    @Override
    public int getObjectLayer() {
        long bodySettingsVa = this.va();
        int result = SoftBodyCreationSettings.getObjectLayer(bodySettingsVa);
        return result;
    }

    @Override
    public RVec3 getPosition() {
        long bodySettingsVa = this.va();
        double xx = SoftBodyCreationSettings.getPositionX(bodySettingsVa);
        assert (Double.isFinite(xx)) : "xx = " + xx;
        double yy = SoftBodyCreationSettings.getPositionY(bodySettingsVa);
        assert (Double.isFinite(yy)) : "yy = " + yy;
        double zz = SoftBodyCreationSettings.getPositionZ(bodySettingsVa);
        assert (Double.isFinite(zz)) : "zz = " + zz;
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    @Override
    public float getPressure() {
        long bodySettingsVa = this.va();
        float result = SoftBodyCreationSettings.getPressure(bodySettingsVa);
        return result;
    }

    @Override
    public float getRestitution() {
        long bodySettingsVa = this.va();
        float result = SoftBodyCreationSettings.getRestitution(bodySettingsVa);
        return result;
    }

    @Override
    public Quat getRotation() {
        long bodySettingsVa = this.va();
        float qw = SoftBodyCreationSettings.getRotationW(bodySettingsVa);
        float qx = SoftBodyCreationSettings.getRotationX(bodySettingsVa);
        float qy = SoftBodyCreationSettings.getRotationY(bodySettingsVa);
        float qz = SoftBodyCreationSettings.getRotationZ(bodySettingsVa);
        Quat result = new Quat(qx, qy, qz, qw);
        return result;
    }

    @Override
    public ConstSoftBodySharedSettings getSettings() {
        long bodySettingsVa = this.va();
        long sharedSettingsVa = SoftBodyCreationSettings.getSettings(bodySettingsVa);
        SoftBodySharedSettings result = sharedSettingsVa == 0L ? null : new SoftBodySharedSettings(sharedSettingsVa);
        return result;
    }

    @Override
    public boolean getUpdatePosition() {
        long bodySettingsVa = this.va();
        boolean result = SoftBodyCreationSettings.getUpdatePosition(bodySettingsVa);
        return result;
    }

    @Override
    public long getUserData() {
        long bodySettingsVa = this.va();
        long result = SoftBodyCreationSettings.getUserData(bodySettingsVa);
        return result;
    }

    @Override
    public float getVertexRadius() {
        long bodySettingsVa = this.va();
        float result = SoftBodyCreationSettings.getVertexRadius(bodySettingsVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long bodySettingsVa = this.va();
        long streamVa = stream.va();
        SoftBodyCreationSettings.saveBinaryState(bodySettingsVa, streamVa);
    }

    @Override
    public void saveWithChildren(StreamOut stream, SharedSettingsToIdMap sbssMap, MaterialToIdMap materialMap, GroupFilterToIdMap filterMap) {
        long bodySettingsVa = this.va();
        long streamVa = stream.va();
        long sbssMapVa = sbssMap == null ? 0L : sbssMap.va();
        long materialMapVa = materialMap == null ? 0L : materialMap.va();
        long filterMapVa = filterMap == null ? 0L : filterMap.va();
        SoftBodyCreationSettings.saveWithChildren(bodySettingsVa, streamVa, sbssMapVa, materialMapVa, filterMapVa);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createFromSharedSettings(long var0, double var2, double var4, double var6, float var8, float var9, float var10, float var11, int var12);

    private static native void free(long var0);

    private static native boolean getAllowSleeping(long var0);

    private static native long getCollisionGroup(long var0);

    private static native boolean getFacesDoubleSided(long var0);

    private static native float getFriction(long var0);

    private static native float getGravityFactor(long var0);

    private static native float getLinearDamping(long var0);

    private static native boolean getMakeRotationIdentity(long var0);

    private static native float getMaxLinearVelocity(long var0);

    private static native int getNumIterations(long var0);

    private static native int getObjectLayer(long var0);

    private static native double getPositionX(long var0);

    private static native double getPositionY(long var0);

    private static native double getPositionZ(long var0);

    private static native float getPressure(long var0);

    private static native float getRestitution(long var0);

    private static native float getRotationW(long var0);

    private static native float getRotationX(long var0);

    private static native float getRotationY(long var0);

    private static native float getRotationZ(long var0);

    private static native long getSettings(long var0);

    private static native boolean getUpdatePosition(long var0);

    private static native long getUserData(long var0);

    static native float getVertexRadius(long var0);

    private static native void restoreBinaryState(long var0, long var2);

    private static native void saveBinaryState(long var0, long var2);

    private static native void saveWithChildren(long var0, long var2, long var4, long var6, long var8);

    private static native void setAllowSleeping(long var0, boolean var2);

    private static native void setCollisionGroup(long var0, long var2);

    private static native void setFacesDoubleSided(long var0, boolean var2);

    private static native void setFriction(long var0, float var2);

    private static native void setGravityFactor(long var0, float var2);

    private static native void setLinearDamping(long var0, float var2);

    private static native void setMakeRotationIdentity(long var0, boolean var2);

    private static native void setMaxLinearVelocity(long var0, float var2);

    private static native void setNumIterations(long var0, int var2);

    private static native void setObjectLayer(long var0, int var2);

    private static native void setPosition(long var0, double var2, double var4, double var6);

    private static native void setPressure(long var0, float var2);

    private static native void setRestitution(long var0, float var2);

    private static native void setRotation(long var0, float var2, float var3, float var4, float var5);

    private static native void setSettings(long var0, long var2);

    private static native void setUpdatePosition(long var0, boolean var2);

    private static native void setUserData(long var0, long var2);

    static native void setVertexRadius(long var0, float var2);

    private static native long sRestoreWithChildren(long var0, long var2, long var4, long var6);
}

