/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EMotorState;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class SwingTwistConstraint
extends TwoBodyConstraint {
    SwingTwistConstraint(long constraintVa) {
        this.setVirtualAddressAsCoOwner(constraintVa);
    }

    public MotorSettings getSwingMotorSettings() {
        long constraintVa = this.va();
        long settingsVa = SwingTwistConstraint.getSwingMotorSettings(constraintVa);
        MotorSettings result = new MotorSettings(this, settingsVa);
        return result;
    }

    public EMotorState getSwingMotorState() {
        long constraintVa = this.va();
        int ordinal = SwingTwistConstraint.getSwingMotorState(constraintVa);
        EMotorState result = EMotorState.values()[ordinal];
        return result;
    }

    public Vec3 getTargetAngularVelocityCs() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SwingTwistConstraint.getTargetAngularVelocityCs(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Quat getTargetOrientationCs() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SwingTwistConstraint.getTargetOrientationCs(constraintVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    public MotorSettings getTwistMotorSettings() {
        long constraintVa = this.va();
        long settingsVa = SwingTwistConstraint.getTwistMotorSettings(constraintVa);
        MotorSettings result = new MotorSettings(this, settingsVa);
        return result;
    }

    public EMotorState getTwistMotorState() {
        long constraintVa = this.va();
        int ordinal = SwingTwistConstraint.getTwistMotorState(constraintVa);
        EMotorState result = EMotorState.values()[ordinal];
        return result;
    }

    public void setMaxFrictionTorque(float torque) {
        long settingsVa = this.va();
        SwingTwistConstraint.setMaxFrictionTorque(settingsVa, torque);
    }

    public void setNormalHalfConeAngle(float angle) {
        long settingsVa = this.va();
        SwingTwistConstraint.setNormalHalfConeAngle(settingsVa, angle);
    }

    public void setPlaneHalfConeAngle(float angle) {
        long settingsVa = this.va();
        SwingTwistConstraint.setPlaneHalfConeAngle(settingsVa, angle);
    }

    public void setSwingMotorState(EMotorState motorState) {
        long settingsVa = this.va();
        int ordinal = motorState.ordinal();
        SwingTwistConstraint.setSwingMotorState(settingsVa, ordinal);
    }

    public void setTwistMaxAngle(float angle) {
        long settingsVa = this.va();
        SwingTwistConstraint.setTwistMaxAngle(settingsVa, angle);
    }

    public void setTwistMinAngle(float angle) {
        long settingsVa = this.va();
        SwingTwistConstraint.setTwistMinAngle(settingsVa, angle);
    }

    public void setTwistMotorState(EMotorState motorState) {
        long settingsVa = this.va();
        int ordinal = motorState.ordinal();
        SwingTwistConstraint.setTwistMotorState(settingsVa, ordinal);
    }

    public void setTargetAngularVelocityCs(Vec3Arg omega) {
        long settingsVa = this.va();
        float wx = omega.getX();
        float wy = omega.getY();
        float wz = omega.getZ();
        SwingTwistConstraint.setTargetAngularVelocityCs(settingsVa, wx, wy, wz);
    }

    public void setTargetOrientationCs(QuatArg orientation) {
        long settingsVa = this.va();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        SwingTwistConstraint.setTargetOrientationCs(settingsVa, qx, qy, qz, qw);
    }

    private static native long getSwingMotorSettings(long var0);

    private static native int getSwingMotorState(long var0);

    private static native void getTargetAngularVelocityCs(long var0, FloatBuffer var2);

    private static native void getTargetOrientationCs(long var0, FloatBuffer var2);

    private static native long getTwistMotorSettings(long var0);

    private static native int getTwistMotorState(long var0);

    private static native void setMaxFrictionTorque(long var0, float var2);

    private static native void setNormalHalfConeAngle(long var0, float var2);

    private static native void setPlaneHalfConeAngle(long var0, float var2);

    private static native void setSwingMotorState(long var0, int var2);

    private static native void setTwistMaxAngle(long var0, float var2);

    private static native void setTwistMinAngle(long var0, float var2);

    private static native void setTwistMotorState(long var0, int var2);

    private static native void setTargetAngularVelocityCs(long var0, float var2, float var3, float var4);

    private static native void setTargetOrientationCs(long var0, float var2, float var3, float var4, float var5);
}

