/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConstraintSettings;
import com.github.stephengold.joltjni.Rtti;
import com.github.stephengold.joltjni.SerializableObject;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleAntiRollBar;
import com.github.stephengold.joltjni.VehicleConstraintSettings;
import com.github.stephengold.joltjni.VehicleControllerSettings;
import com.github.stephengold.joltjni.WheelSettings;
import com.github.stephengold.joltjni.readonly.ConstVehicleConstraintSettings;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.Ref;
import java.nio.FloatBuffer;

public final class VehicleConstraintSettingsRef
extends Ref
implements ConstVehicleConstraintSettings {
    public VehicleConstraintSettingsRef() {
        long refVa = VehicleConstraintSettingsRef.createDefault();
        this.setVirtualAddress(refVa, () -> VehicleConstraintSettingsRef.free(refVa));
    }

    VehicleConstraintSettingsRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> VehicleConstraintSettingsRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void addWheels(WheelSettings ... wheelSettingsArray) {
        long constraintSettingsVa = this.targetVa();
        for (WheelSettings wheelSettings : wheelSettingsArray) {
            long wheelSettingsVa = wheelSettings.va();
            VehicleConstraintSettings.addWheel(constraintSettingsVa, wheelSettingsVa);
        }
    }

    public void setController(VehicleControllerSettings controllerSettings) {
        long constraintSettingsVa = this.targetVa();
        long controllerSettingsVa = controllerSettings.va();
        VehicleConstraintSettings.setController(constraintSettingsVa, controllerSettingsVa);
        int controllerType = controllerSettings.controllerTypeOrdinal();
        ConstraintSettings.setControllerType(constraintSettingsVa, controllerType);
    }

    public void setForward(Vec3Arg forward) {
        long settingsVa = this.targetVa();
        float dx = forward.getX();
        float dy = forward.getY();
        float dz = forward.getZ();
        VehicleConstraintSettings.setForward(settingsVa, dx, dy, dz);
    }

    public void setMaxPitchRollAngle(float angle) {
        long settingsVa = this.targetVa();
        VehicleConstraintSettings.setMaxPitchRollAngle(settingsVa, angle);
    }

    public void setNumAntiRollBars(int count) {
        long settingsVa = this.targetVa();
        VehicleConstraintSettings.setNumAntiRollBars(settingsVa, count);
    }

    public void setUp(Vec3Arg up) {
        long settingsVa = this.targetVa();
        float dx = up.getX();
        float dy = up.getY();
        float dz = up.getZ();
        VehicleConstraintSettings.setUp(settingsVa, dx, dy, dz);
    }

    @Override
    public VehicleAntiRollBar getAntiRollBar(int barIndex) {
        long settingsVa = this.targetVa();
        long barVa = VehicleConstraintSettings.getAntiRollBar(settingsVa, barIndex);
        VehicleAntiRollBar result = new VehicleAntiRollBar(this, barVa);
        return result;
    }

    @Override
    public int getConstraintPriority() {
        long settingsVa = this.targetVa();
        int result = ConstraintSettings.getConstraintPriority(settingsVa);
        return result;
    }

    @Override
    public VehicleControllerSettings getController() {
        long constraintSettingsVa = this.targetVa();
        long controllerSettingsVa = VehicleConstraintSettings.getController(constraintSettingsVa);
        VehicleControllerSettings result = VehicleControllerSettings.newSettings(controllerSettingsVa);
        return result;
    }

    @Override
    public int getControllerType() {
        long settingsVa = this.targetVa();
        int result = ConstraintSettings.getControllerType(settingsVa);
        return result;
    }

    @Override
    public float getDrawConstraintSize() {
        long settingsVa = this.targetVa();
        float result = ConstraintSettings.getDrawConstraintSize(settingsVa);
        return result;
    }

    @Override
    public boolean getEnabled() {
        long settingsVa = this.targetVa();
        boolean result = ConstraintSettings.getEnabled(settingsVa);
        return result;
    }

    @Override
    public Vec3 getForward() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraintSettings.getForward(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getMaxPitchRollAngle() {
        long settingsVa = this.targetVa();
        float result = VehicleConstraintSettings.getMaxPitchRollAngle(settingsVa);
        return result;
    }

    @Override
    public int getNumAntiRollBars() {
        long settingsVa = this.targetVa();
        int result = VehicleConstraintSettings.getNumAntiRollBars(settingsVa);
        return result;
    }

    @Override
    public int getNumPositionStepsOverride() {
        long settingsVa = this.targetVa();
        int result = ConstraintSettings.getNumPositionStepsOverride(settingsVa);
        return result;
    }

    @Override
    public int getNumVelocityStepsOverride() {
        long settingsVa = this.targetVa();
        int result = ConstraintSettings.getNumVelocityStepsOverride(settingsVa);
        return result;
    }

    @Override
    public int getNumWheels() {
        long settingsVa = this.targetVa();
        int result = VehicleConstraintSettings.getNumWheels(settingsVa);
        return result;
    }

    @Override
    public Rtti getRtti() {
        long jpoVa = this.targetVa();
        long resultVa = SerializableObject.getRtti(jpoVa);
        Rtti result = new Rtti(resultVa);
        return result;
    }

    @Override
    public Vec3 getUp() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraintSettings.getUp(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public WheelSettings getWheel(int wheelIndex) {
        long constraintSettingsVa = this.targetVa();
        long wheelSettingsVa = VehicleConstraintSettings.getWheel(constraintSettingsVa, wheelIndex);
        WheelSettings result = WheelSettings.newSettings(wheelSettingsVa);
        return result;
    }

    public WheelSettings[] getWheels() {
        long constraintSettingsVa = this.targetVa();
        int numWheels = VehicleConstraintSettings.getNumWheels(constraintSettingsVa);
        WheelSettings[] result = new WheelSettings[numWheels];
        for (int wheelIndex = 0; wheelIndex < numWheels; ++wheelIndex) {
            WheelSettings ws;
            long wheelSettingsVa = VehicleConstraintSettings.getWheel(constraintSettingsVa, wheelIndex);
            result[wheelIndex] = ws = WheelSettings.newSettings(wheelSettingsVa);
        }
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long settingsVa = this.targetVa();
        long streamVa = stream.va();
        ConstraintSettings.saveBinaryState(settingsVa, streamVa);
    }

    @Override
    public VehicleConstraintSettings getPtr() {
        long settingsVa = this.targetVa();
        VehicleConstraintSettings result = (VehicleConstraintSettings)ConstraintSettings.newConstraintSettings(settingsVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = VehicleConstraintSettingsRef.getPtr(refVa);
        return result;
    }

    @Override
    public VehicleConstraintSettingsRef toRef() {
        long refVa = this.va();
        long copyVa = VehicleConstraintSettingsRef.copy(refVa);
        VehicleConstraintSettingsRef result = new VehicleConstraintSettingsRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native long getPtr(long var0);
}

