/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.MotorcycleController;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.TrackedVehicleController;
import com.github.stephengold.joltjni.VehicleConstraint;
import com.github.stephengold.joltjni.VehicleControllerSettings;
import com.github.stephengold.joltjni.WheeledVehicleController;
import com.github.stephengold.joltjni.readonly.ConstVehicleController;

public class VehicleController
extends NonCopyable
implements ConstVehicleController {
    static final int genericType = 1;
    static final int motorcycleType = 2;
    static final int trackedVehicleType = 3;
    static final int wheeledVehicleType = 4;

    VehicleController(VehicleConstraint container, long virtualAddress) {
        super(container, virtualAddress);
    }

    public VehicleConstraint getConstraint() {
        return (VehicleConstraint)this.getContainingObject();
    }

    static VehicleController newController(VehicleConstraint container, long controllerVa) {
        VehicleController result;
        if (controllerVa == 0L) {
            return null;
        }
        long constraintVa = VehicleController.getConstraint(controllerVa);
        int ordinal = Constraint.getControllerType(constraintVa);
        switch (ordinal) {
            case 2: {
                result = new MotorcycleController(container, controllerVa);
                break;
            }
            case 3: {
                result = new TrackedVehicleController(container, controllerVa);
                break;
            }
            case 4: {
                result = new WheeledVehicleController(container, controllerVa);
                break;
            }
            default: {
                throw new IllegalArgumentException("ordinal = " + ordinal);
            }
        }
        return result;
    }

    @Override
    public VehicleControllerSettings getSettings() {
        long controllerVa = this.va();
        long settingsVa = VehicleController.getSettings(controllerVa);
        VehicleControllerSettings result = new VehicleControllerSettings(settingsVa);
        return result;
    }

    private static native long getConstraint(long var0);

    private static native long getSettings(long var0);
}

