/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.readonly.ConstVolume;

public class Volume
extends JoltPhysicsObject
implements ConstVolume {
    public Volume() {
        long volumeVa = Volume.createDefault();
        this.setVirtualAddress(volumeVa, () -> Volume.free(volumeVa));
    }

    public void setCompliance(float compliance) {
        long volumeVa = this.va();
        Volume.setCompliance(volumeVa, compliance);
    }

    public void setSixRestVolume(float sixVolume) {
        long volumeVa = this.va();
        Volume.setSixRestVolume(volumeVa, sixVolume);
    }

    public void setVertex(int indexInVolume, int indexInMesh) {
        long volumeVa = this.va();
        Volume.setVertex(volumeVa, indexInVolume, indexInMesh);
    }

    @Override
    public float getCompliance() {
        long volumeVa = this.va();
        float result = Volume.getCompliance(volumeVa);
        return result;
    }

    @Override
    public float getSixRestVolume() {
        long volumeVa = this.va();
        float result = Volume.getSixRestVolume(volumeVa);
        return result;
    }

    @Override
    public int getVertex(int indexInVolume) {
        long volumeVa = this.va();
        int result = Volume.getVertex(volumeVa, indexInVolume);
        return result;
    }

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getCompliance(long var0);

    private static native float getSixRestVolume(long var0);

    private static native int getVertex(long var0, int var2);

    private static native void setCompliance(long var0, float var2);

    private static native void setSixRestVolume(long var0, float var2);

    private static native void setVertex(long var0, int var2, int var3);
}

