/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.VehicleConstraint;
import com.github.stephengold.joltjni.VehicleController;
import com.github.stephengold.joltjni.VehicleDifferentialSettings;
import com.github.stephengold.joltjni.VehicleEngine;
import com.github.stephengold.joltjni.VehicleTransmission;

public class WheeledVehicleController
extends VehicleController {
    WheeledVehicleController(VehicleConstraint constraint, long controllerVa) {
        super(constraint, controllerVa);
    }

    public float getBrakeInput() {
        long controllerVa = this.va();
        float result = WheeledVehicleController.getBrakeInput(controllerVa);
        return result;
    }

    public VehicleDifferentialSettings[] getDifferentials() {
        long controllerVa = this.va();
        int numDifferentials = WheeledVehicleController.countDifferentials(controllerVa);
        VehicleDifferentialSettings[] result = new VehicleDifferentialSettings[numDifferentials];
        JoltPhysicsObject container = this.getContainingObject();
        for (int i = 0; i < numDifferentials; ++i) {
            long settingsVa = WheeledVehicleController.getDifferential(controllerVa, i);
            result[i] = new VehicleDifferentialSettings(container, settingsVa);
        }
        return result;
    }

    public VehicleEngine getEngine() {
        long controllerVa = this.va();
        long engineVa = WheeledVehicleController.getEngine(controllerVa);
        JoltPhysicsObject container = this.getContainingObject();
        VehicleEngine result = new VehicleEngine(container, engineVa);
        return result;
    }

    public float getForwardInput() {
        long controllerVa = this.va();
        float result = WheeledVehicleController.getForwardInput(controllerVa);
        return result;
    }

    public float getHandBrakeInput() {
        long controllerVa = this.va();
        float result = WheeledVehicleController.getHandBrakeInput(controllerVa);
        return result;
    }

    public float getRightInput() {
        long controllerVa = this.va();
        float result = WheeledVehicleController.getRightInput(controllerVa);
        return result;
    }

    public VehicleTransmission getTransmission() {
        long controllerVa = this.va();
        long transmissionVa = WheeledVehicleController.getTransmission(controllerVa);
        JoltPhysicsObject container = this.getContainingObject();
        VehicleTransmission result = new VehicleTransmission(container, transmissionVa);
        return result;
    }

    public void setBrakeInput(float pressure) {
        long controllerVa = this.va();
        WheeledVehicleController.setBrakeInput(controllerVa, pressure);
    }

    public void setDifferentialLimitedSlipRatio(float ratio) {
        long controllerVa = this.va();
        WheeledVehicleController.setDifferentialLimitedSlipRatio(controllerVa, ratio);
    }

    public void setDriverInput(float forward, float right, float brake, float handBrake) {
        long controllerVa = this.va();
        WheeledVehicleController.setDriverInput(controllerVa, forward, right, brake, handBrake);
    }

    public void setForwardInput(float forward) {
        long controllerVa = this.va();
        WheeledVehicleController.setForwardInput(controllerVa, forward);
    }

    public void setHandBrakeInput(float pressure) {
        long controllerVa = this.va();
        WheeledVehicleController.setHandBrakeInput(controllerVa, pressure);
    }

    public void setRightInput(float right) {
        long controllerVa = this.va();
        WheeledVehicleController.setRightInput(controllerVa, right);
    }

    private static native int countDifferentials(long var0);

    private static native float getBrakeInput(long var0);

    private static native long getDifferential(long var0, int var2);

    private static native long getEngine(long var0);

    private static native float getForwardInput(long var0);

    private static native float getHandBrakeInput(long var0);

    private static native float getRightInput(long var0);

    private static native long getTransmission(long var0);

    private static native void setBrakeInput(long var0, float var2);

    private static native void setDifferentialLimitedSlipRatio(long var0, float var2);

    private static native void setDriverInput(long var0, float var2, float var3, float var4, float var5);

    private static native void setForwardInput(long var0, float var2);

    private static native void setHandBrakeInput(long var0, float var2);

    private static native void setRightInput(long var0, float var2);
}

