/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.drivable.motorcycle;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.WheelSettingsWv;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxRigidBodyRenderer;
import net.xmx.velthoric.physics.vehicle.type.motorcycle.VxMotorcycle;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheelRenderState;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MotorcycleRenderer
extends VxRigidBodyRenderer<VxMotorcycle> {
    private static final class_2680 CHASSIS_STATE = class_2246.field_10038.method_9564();
    private static final class_2680 WHEEL_STATE = class_2246.field_10458.method_9564();

    @Override
    public void render(VxMotorcycle body, class_4587 poseStack, class_4597.class_4598 bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        poseStack.method_22903();
        RVec3 renderPosition = renderState.transform.getTranslation();
        Quat renderRotation = renderState.transform.getRotation();
        poseStack.method_46416(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.method_22907(new Quaternionf(renderRotation.getX(), renderRotation.getY(), renderRotation.getZ(), renderRotation.getW()));
        Vec3 halfExtents = body.getChassisHalfExtents();
        poseStack.method_22903();
        poseStack.method_46416(-halfExtents.getX(), -halfExtents.getY(), -halfExtents.getZ());
        poseStack.method_22905(halfExtents.getX() * 2.0f, halfExtents.getY() * 2.0f, halfExtents.getZ() * 2.0f);
        class_310.method_1551().method_1541().method_3353(CHASSIS_STATE, poseStack, (class_4597)bufferSource, packedLight, class_4608.field_21444);
        poseStack.method_22909();
        List<WheelSettingsWv> wheelSettingsList = body.getWheelSettings();
        List<VxWheelRenderState> wheelRenderStates = body.getInterpolatedWheelStates();
        if (wheelRenderStates == null || wheelSettingsList.size() != wheelRenderStates.size()) {
            poseStack.method_22909();
            return;
        }
        for (int i = 0; i < wheelSettingsList.size(); ++i) {
            WheelSettingsWv wheelSettings = wheelSettingsList.get(i);
            VxWheelRenderState wheelState = wheelRenderStates.get(i);
            if (wheelState == null) continue;
            poseStack.method_22903();
            Vec3 attachmentPos = wheelSettings.getPosition();
            poseStack.method_46416(attachmentPos.getX(), attachmentPos.getY(), attachmentPos.getZ());
            Vec3 suspensionDir = wheelSettings.getSuspensionDirection();
            poseStack.method_46416(suspensionDir.getX() * wheelState.suspensionLength(), suspensionDir.getY() * wheelState.suspensionLength(), suspensionDir.getZ() * wheelState.suspensionLength());
            Vec3 steerAxis = wheelSettings.getSteeringAxis();
            poseStack.method_22907(class_7833.method_46356((Vector3f)new Vector3f(steerAxis.getX(), steerAxis.getY(), steerAxis.getZ())).rotation(wheelState.steerAngle()));
            poseStack.method_22907(class_7833.field_40714.rotation(wheelState.rotationAngle()));
            float radius = wheelSettings.getRadius();
            float width = wheelSettings.getWidth();
            poseStack.method_22903();
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            poseStack.method_46416(-radius, -width / 2.0f, -radius);
            poseStack.method_22905(radius * 2.0f, width, radius * 2.0f);
            class_310.method_1551().method_1541().method_3353(WHEEL_STATE, poseStack, (class_4597)bufferSource, packedLight, class_4608.field_21444);
            poseStack.method_22909();
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }
}

