/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class SpawnBoxGridTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnBoxGrid";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9735((boolean)true)).then(class_2170.method_9244((String)"gridSizeX", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"gridSizeY", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"gridSizeZ", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"boxSize", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(class_2170.method_9244((String)"spacing", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(this::executeGridWithSpacing)))))));
    }

    private int executeGridWithSpacing(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 serverLevel = source.method_9225();
        class_243 initialPos = class_2277.method_9736(context, (String)"position");
        int gridSizeX = IntegerArgumentType.getInteger(context, (String)"gridSizeX");
        int gridSizeY = IntegerArgumentType.getInteger(context, (String)"gridSizeY");
        int gridSizeZ = IntegerArgumentType.getInteger(context, (String)"gridSizeZ");
        float boxSize = FloatArgumentType.getFloat(context, (String)"boxSize");
        float spacing = FloatArgumentType.getFloat(context, (String)"spacing");
        int spawnedCount = 0;
        float halfExtent = boxSize / 2.0f;
        Vec3 halfExtents = new Vec3(halfExtent, halfExtent, halfExtent);
        float step = boxSize + spacing;
        for (int i = 0; i < gridSizeX; ++i) {
            for (int j = 0; j < gridSizeY; ++j) {
                for (int k = 0; k < gridSizeZ; ++k) {
                    double x = initialPos.field_1352 + (double)((float)i * step);
                    double y = initialPos.field_1351 + (double)((float)j * step);
                    double z = initialPos.field_1350 + (double)((float)k * step);
                    if (this.spawn(serverLevel, new class_243(x, y, z), halfExtents) != 1) continue;
                    ++spawnedCount;
                }
            }
        }
        int finalSpawnedCount = spawnedCount;
        source.method_9226(() -> class_2561.method_43470((String)String.format("Successfully spawned %d boxes in a %dx%dx%d grid with spacing %.2f.", finalSpawnedCount, gridSizeX, gridSizeY, gridSizeZ, Float.valueOf(spacing))), true);
        return spawnedCount;
    }

    private int spawn(class_3218 serverLevel, class_243 spawnPosMc, Vec3 halfExtents) {
        VxTransform transform;
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)serverLevel.method_27983());
        if (physicsWorld == null) {
            return 0;
        }
        VxBodyManager manager = physicsWorld.getBodyManager();
        BoxRigidBody spawnedBody = manager.createRigidBody(VxRegisteredBodies.BOX, transform = new VxTransform(new RVec3(spawnPosMc.field_1352, spawnPosMc.field_1351, spawnPosMc.field_1350), Quat.sIdentity()), box -> box.setHalfExtents(halfExtents));
        return spawnedBody != null ? 1 : 0;
    }
}

