/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class SpawnBoxTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnBox";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9735((boolean)true)).then(class_2170.method_9244((String)"halfWidth", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).then(class_2170.method_9244((String)"halfHeight", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).then(class_2170.method_9244((String)"halfDepth", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).executes(this::executeFull))))).then(class_2170.method_9244((String)"size", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).executes(this::executeSized))).executes(this::executeDefault));
    }

    private int executeFull(CommandContext<class_2168> context) throws CommandSyntaxException {
        float halfWidth = FloatArgumentType.getFloat(context, (String)"halfWidth");
        float halfHeight = FloatArgumentType.getFloat(context, (String)"halfHeight");
        float halfDepth = FloatArgumentType.getFloat(context, (String)"halfDepth");
        Vec3 halfExtents = new Vec3(halfWidth, halfHeight, halfDepth);
        return this.spawn((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9225(), class_2277.method_9736(context, (String)"position"), halfExtents);
    }

    private int executeSized(CommandContext<class_2168> context) throws CommandSyntaxException {
        float size = FloatArgumentType.getFloat(context, (String)"size");
        float halfExtent = size / 2.0f;
        Vec3 halfExtents = new Vec3(halfExtent, halfExtent, halfExtent);
        return this.spawn((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9225(), class_2277.method_9736(context, (String)"position"), halfExtents);
    }

    private int executeDefault(CommandContext<class_2168> context) throws CommandSyntaxException {
        Vec3 halfExtents = new Vec3(0.5f, 0.5f, 0.5f);
        return this.spawn((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9225(), class_2277.method_9736(context, (String)"position"), halfExtents);
    }

    private int spawn(class_2168 source, class_3218 serverLevel, class_243 spawnPosMc, Vec3 halfExtents) {
        VxTransform transform;
        if (halfExtents.getX() <= 0.0f || halfExtents.getY() <= 0.0f || halfExtents.getZ() <= 0.0f) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Box dimensions (halfExtents) must be positive."));
            return 0;
        }
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)serverLevel.method_27983());
        if (physicsWorld == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Physics system for this dimension is not initialized."));
            return 0;
        }
        VxBodyManager manager = physicsWorld.getBodyManager();
        BoxRigidBody spawnedBody = manager.createRigidBody(VxRegisteredBodies.BOX, transform = new VxTransform(new RVec3(spawnPosMc.field_1352, spawnPosMc.field_1351, spawnPosMc.field_1350), Quat.sIdentity()), box -> box.setHalfExtents(halfExtents));
        if (spawnedBody != null) {
            source.method_9226(() -> class_2561.method_43470((String)String.format("Successfully spawned box (%.2f x %.2f x %.2f) with ID: %s", Float.valueOf(halfExtents.getX() * 2.0f), Float.valueOf(halfExtents.getY() * 2.0f), Float.valueOf(halfExtents.getZ() * 2.0f), spawnedBody.getPhysicsId())), true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Failed to register the box. Check logs for details."));
        return 0;
    }
}

