/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.magnetizer;

import com.github.stephengold.joltjni.AllHitCollideShapeBodyCollector;
import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyLockWrite;
import com.github.stephengold.joltjni.BroadPhaseLayerFilter;
import com.github.stephengold.joltjni.ObjectLayerFilter;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.ConstBroadPhaseQuery;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_5321;
import net.xmx.velthoric.physics.raycasting.VxClipContext;
import net.xmx.velthoric.physics.raycasting.VxHitResult;
import net.xmx.velthoric.physics.raycasting.VxRaycaster;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxMagnetizerManager {
    private static final VxMagnetizerManager INSTANCE = new VxMagnetizerManager();
    private final Map<UUID, MagnetMode> playerModes = new ConcurrentHashMap<UUID, MagnetMode>();
    private static final float MAGNET_RADIUS = 100.0f;
    private static final float TARGET_DISTANCE = 100.0f;
    private static final float BASE_ATTRACT_FORCE = 2000.0f;
    private static final float BASE_REPEL_FORCE = 3000.0f;

    private VxMagnetizerManager() {
    }

    public static VxMagnetizerManager getInstance() {
        return INSTANCE;
    }

    public void startAttract(class_3222 player) {
        this.playerModes.put(player.method_5667(), MagnetMode.ATTRACT);
    }

    public void startRepel(class_3222 player) {
        this.playerModes.put(player.method_5667(), MagnetMode.REPEL);
    }

    public void stop(class_3222 player) {
        this.playerModes.put(player.method_5667(), MagnetMode.INACTIVE);
    }

    public boolean isActing(class_3222 player) {
        return this.playerModes.getOrDefault(player.method_5667(), MagnetMode.INACTIVE) != MagnetMode.INACTIVE;
    }

    public void serverTick(class_3222 player) {
        class_243 lookVec;
        class_243 rayEnd;
        MagnetMode mode = this.playerModes.getOrDefault(player.method_5667(), MagnetMode.INACTIVE);
        if (mode == MagnetMode.INACTIVE) {
            return;
        }
        class_1937 level = player.method_37908();
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)level.method_27983());
        if (physicsWorld == null || !physicsWorld.isRunning()) {
            this.stop(player);
            return;
        }
        class_243 eyePos = player.method_33571();
        VxClipContext context = new VxClipContext(eyePos, rayEnd = eyePos.method_1019((lookVec = player.method_5720()).method_1021(100.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player, true);
        Optional<VxHitResult> hitResult = VxRaycaster.raycast(level, context);
        class_243 targetPoint = hitResult.isPresent() ? hitResult.get().method_17784() : rayEnd;
        RVec3 targetPointRVec = new RVec3((float)targetPoint.method_10216(), (float)targetPoint.method_10214(), (float)targetPoint.method_10215());
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_2400 particleType = mode == MagnetMode.ATTRACT ? class_2398.field_11207 : class_2398.field_11240;
            serverLevel.method_14166(player, (class_2394)particleType, true, (double)targetPointRVec.x(), (double)targetPointRVec.y(), (double)targetPointRVec.z(), 5, 0.1, 0.1, 0.1, 0.0);
        }
        physicsWorld.execute(() -> {
            int[] hitBodyIds;
            PhysicsSystem physicsSystem = physicsWorld.getPhysicsSystem();
            if (physicsSystem == null) {
                return;
            }
            ConstBroadPhaseQuery broadPhaseQuery = physicsSystem.getBroadPhaseQuery();
            AllHitCollideShapeBodyCollector collector = new AllHitCollideShapeBodyCollector();
            BroadPhaseLayerFilter broadPhaseFilter = new BroadPhaseLayerFilter();
            ObjectLayerFilter objectFilter = new ObjectLayerFilter();
            broadPhaseQuery.collideSphere(targetPointRVec.toVec3(), 100.0f, collector, broadPhaseFilter, objectFilter);
            for (int bodyId : hitBodyIds = collector.getHits()) {
                physicsWorld.getPhysicsSystem().getBodyInterface().activateBody(bodyId);
                try (BodyLockWrite lock = new BodyLockWrite(physicsSystem.getBodyLockInterface(), bodyId);){
                    Body body;
                    RVec3 bodyPos;
                    RVec3 vectorToBody;
                    double distance;
                    if (!lock.succeededAndIsInBroadPhase() || !lock.getBody().isDynamic() || (distance = (vectorToBody = Op.minus((RVec3Arg)(bodyPos = (body = lock.getBody()).getCenterOfMassPosition()), targetPointRVec)).length()) < 1.0E-5) continue;
                    float forceMagnitude = (float)((double)(mode == MagnetMode.ATTRACT ? 2000.0f : 3000.0f) * distance);
                    Vec3 forceDirection = vectorToBody.toVec3().normalized();
                    if (mode == MagnetMode.ATTRACT) {
                        forceDirection.scaleInPlace(-1.0f);
                    }
                    Vec3 finalForce = Op.star((Vec3Arg)forceDirection, forceMagnitude);
                    body.addForce(finalForce);
                }
            }
            collector.close();
        });
    }

    private static enum MagnetMode {
        INACTIVE,
        ATTRACT,
        REPEL;

    }
}

