/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.beam;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.xmx.velthoric.event.api.VxRenderEvent;
import net.xmx.velthoric.item.physicsgun.manager.VxPhysicsGunClientManager;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyInterpolator;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class VxPhysicsGunBeamRenderer {
    private static final int BEAM_SEGMENTS = 20;
    private static final float BEAM_WIDTH = 0.15f;
    private static final float BEAM_CURVE_STRENGTH = 0.3f;
    private static final float BEAM_MAX_LENGTH = 100.0f;
    private static final RVec3 INTERPOLATED_POSITION = new RVec3();
    private static final Quat INTERPOLATED_ROTATION = new Quat();

    public static void registerEvents() {
        VxRenderEvent.ClientRenderLevelStageEvent.EVENT.register(VxPhysicsGunBeamRenderer::onRenderLevelStage);
    }

    public static void onRenderLevelStage(VxRenderEvent.ClientRenderLevelStageEvent event) {
        if (event.getStage() != VxRenderEvent.ClientRenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 localPlayer = mc.field_1724;
        if (localPlayer == null || mc.field_1687 == null) {
            return;
        }
        class_4587 poseStack = event.getPoseStack();
        float partialTicks = event.getPartialTick();
        VxPhysicsGunClientManager clientManager = VxPhysicsGunClientManager.getInstance();
        VxClientBodyManager bodyManager = VxClientBodyManager.getInstance();
        VxClientBodyDataStore store = bodyManager.getStore();
        VxClientBodyInterpolator interpolator = bodyManager.getInterpolator();
        class_4184 camera = mc.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        poseStack.method_22903();
        poseStack.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        Map<UUID, VxPhysicsGunClientManager.ClientGrabData> activeGrabs = clientManager.getActiveGrabs();
        for (Map.Entry<UUID, VxPhysicsGunClientManager.ClientGrabData> entry : activeGrabs.entrySet()) {
            UUID playerUuid = entry.getKey();
            VxPhysicsGunClientManager.ClientGrabData grabData = entry.getValue();
            UUID objectUuid = grabData.objectUuid();
            class_1657 player = mc.field_1687.method_18470(playerUuid);
            if (player == null) continue;
            Integer index = store.getIndexForId(objectUuid);
            VxBody body = bodyManager.getBody(objectUuid);
            if (index == null || !store.render_isInitialized[index] || !(body instanceof VxRigidBody)) continue;
            interpolator.interpolateFrame(store, index, partialTicks, INTERPOLATED_POSITION, INTERPOLATED_ROTATION);
            class_243 startPoint = VxPhysicsGunBeamRenderer.getGunTipPosition(player, partialTicks);
            RVec3 centerPos = INTERPOLATED_POSITION;
            Quat rotation = INTERPOLATED_ROTATION;
            class_243 localHitPoint = grabData.localHitPoint();
            Vec3 localHitJolt = new Vec3((float)localHitPoint.method_10216(), (float)localHitPoint.method_10214(), (float)localHitPoint.method_10215());
            Vec3 rotatedOffset = Op.star((QuatArg)rotation, (Vec3Arg)localHitJolt);
            RVec3 endPointJolt = Op.plus((RVec3Arg)centerPos, (Vec3Arg)rotatedOffset);
            class_243 endPoint = new class_243(endPointJolt.xx(), endPointJolt.yy(), endPointJolt.zz());
            class_243 playerLookVec = VxPhysicsGunBeamRenderer.getPlayerLookVector(player, partialTicks);
            bufferBuilder.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
            VxPhysicsGunBeamRenderer.drawThickCurvedBeam(bufferBuilder, matrix, camPos, startPoint, endPoint, playerLookVec);
            tesselator.method_1350();
        }
        Set<UUID> playersTryingToGrab = clientManager.getPlayersTryingToGrab();
        for (UUID playerUuid : playersTryingToGrab) {
            class_243 traceEnd;
            class_3959 clipContext;
            class_3965 blockHitResult;
            class_1657 player;
            if (activeGrabs.containsKey(playerUuid) || (player = mc.field_1687.method_18470(playerUuid)) == null) continue;
            class_243 startPoint = VxPhysicsGunBeamRenderer.getGunTipPosition(player, partialTicks);
            class_243 playerLookVec = VxPhysicsGunBeamRenderer.getPlayerLookVector(player, partialTicks);
            class_243 traceStart = player.method_5836(partialTicks);
            Optional<class_243> physicsHitPoint = VxPhysicsGunBeamRenderer.raycastClientPhysicsBodies(traceStart, playerLookVec, 100.0f, store, interpolator, partialTicks);
            class_243 endPoint = physicsHitPoint.isPresent() ? physicsHitPoint.get() : ((blockHitResult = mc.field_1687.method_17742(clipContext = new class_3959(traceStart, traceEnd = traceStart.method_1019(playerLookVec.method_1021(100.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player))).method_17783() == class_239.class_240.field_1333 ? traceEnd : blockHitResult.method_17784());
            bufferBuilder.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
            VxPhysicsGunBeamRenderer.drawThickCurvedBeam(bufferBuilder, matrix, camPos, startPoint, endPoint, playerLookVec);
            tesselator.method_1350();
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    private static Optional<class_243> raycastClientPhysicsBodies(class_243 rayOrigin, class_243 rayDirection, float maxDistance, VxClientBodyDataStore store, VxClientBodyInterpolator interpolator, float partialTicks) {
        double closestHitDist = maxDistance;
        class_243 hitPoint = null;
        double OBJECT_RADIUS = 1.5;
        double OBJECT_RADIUS_SQR = 2.25;
        RVec3 tempPos = new RVec3();
        Quat tempRot = new Quat();
        for (UUID id : store.getAllPhysicsIds()) {
            double t_hit;
            double d2;
            Integer i = store.getIndexForId(id);
            if (i == null || !store.render_isInitialized[i]) continue;
            interpolator.interpolateFrame(store, i, partialTicks, tempPos, tempRot);
            class_243 objectCenter = new class_243(tempPos.xx(), tempPos.yy(), tempPos.zz());
            class_243 originToCenter = objectCenter.method_1020(rayOrigin);
            double t = originToCenter.method_1026(rayDirection);
            if (t < 0.0 || t > closestHitDist || !((d2 = originToCenter.method_1027() - t * t) < 2.25) || !((t_hit = t - Math.sqrt(2.25 - d2)) < closestHitDist) || !(t_hit >= 0.0)) continue;
            closestHitDist = t_hit;
            hitPoint = rayOrigin.method_1019(rayDirection.method_1021(closestHitDist));
        }
        return Optional.ofNullable(hitPoint);
    }

    private static void drawThickCurvedBeam(class_287 bufferBuilder, Matrix4f matrix, class_243 camPos, class_243 start, class_243 end, class_243 playerLookVec) {
        float r = 0.9725f;
        float g = 0.2863f;
        float b = 0.0117f;
        float baseAlpha = 0.83f;
        double distance = start.method_1022(end);
        class_243 p0 = start;
        class_243 p3 = end;
        class_243 p1 = p0.method_1019(playerLookVec.method_1021(distance * (double)0.3f));
        class_243 tangentAtEnd = p0.method_1020(p3).method_1029();
        class_243 p2 = p3.method_1019(tangentAtEnd.method_1021(distance * (double)0.3f));
        class_243 lastPos = p0;
        for (int i = 0; i <= 20; ++i) {
            class_243 segmentDir;
            float t = (float)i / 20.0f;
            class_243 currentPos = VxPhysicsGunBeamRenderer.getCubicBezierPoint(t, p0, p1, p2, p3);
            class_243 viewDir = currentPos.method_1020(camPos).method_1029();
            class_243 class_2432 = segmentDir = i == 0 ? p1.method_1020(p0).method_1029() : currentPos.method_1020(lastPos).method_1029();
            if (segmentDir.method_1027() < 1.0E-6) {
                segmentDir = playerLookVec;
            }
            class_243 side = segmentDir.method_1036(viewDir).method_1029().method_1021((double)0.075f);
            bufferBuilder.method_22918(matrix, (float)(currentPos.field_1352 + side.field_1352), (float)(currentPos.field_1351 + side.field_1351), (float)(currentPos.field_1350 + side.field_1350)).method_22915(r, g, b, baseAlpha).method_1344();
            bufferBuilder.method_22918(matrix, (float)(currentPos.field_1352 - side.field_1352), (float)(currentPos.field_1351 - side.field_1351), (float)(currentPos.field_1350 - side.field_1350)).method_22915(r, g, b, baseAlpha).method_1344();
            lastPos = currentPos;
        }
    }

    private static class_243 getCubicBezierPoint(float t, class_243 p0, class_243 p1, class_243 p2, class_243 p3) {
        float u = 1.0f - t;
        float tt = t * t;
        float uu = u * u;
        float uuu = uu * u;
        float ttt = tt * t;
        class_243 p = p0.method_1021((double)uuu);
        p = p.method_1019(p1.method_1021((double)(3.0f * uu * t)));
        p = p.method_1019(p2.method_1021((double)(3.0f * u * tt)));
        p = p.method_1019(p3.method_1021((double)ttt));
        return p;
    }

    private static class_243 getPlayerLookVector(class_1657 player, float partialTicks) {
        class_310 mc = class_310.method_1551();
        if (player.method_5779((class_1297)mc.field_1724) && mc.field_1690.method_31044().method_31034()) {
            class_4184 camera = mc.field_1773.method_19418();
            Vector3f lookVector = camera.method_19335();
            return new class_243((double)lookVector.x(), (double)lookVector.y(), (double)lookVector.z());
        }
        return player.method_5828(partialTicks);
    }

    private static class_243 getGunTipPosition(class_1657 player, float partialTicks) {
        class_310 mc = class_310.method_1551();
        if (player.method_5779((class_1297)mc.field_1724) && mc.field_1690.method_31044().method_31034()) {
            class_4184 camera = mc.field_1773.method_19418();
            Vector3f lookVector = camera.method_19335();
            class_243 camForward = new class_243((double)lookVector.x(), (double)lookVector.y(), (double)lookVector.z());
            Vector3f upVector = camera.method_19336();
            class_243 camUp = new class_243((double)upVector.x(), (double)upVector.y(), (double)upVector.z());
            class_243 camRight = camForward.method_1036(camUp).method_1029();
            return camera.method_19326().method_1019(camForward.method_1021(0.5)).method_1019(camRight.method_1021(0.3)).method_1019(camUp.method_1021(-0.15));
        }
        class_243 eyePos = player.method_5836(partialTicks);
        class_243 lookVec = player.method_5828(partialTicks);
        class_243 upVec = player.method_18864(partialTicks);
        class_243 rightVec = lookVec.method_1036(upVec).method_1029();
        return eyePos.method_1019(lookVec.method_1021(0.3)).method_1019(rightVec.method_1021(-0.35)).method_1019(upVec.method_1021(-0.3));
    }
}

