/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.manager;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.BodyLockWrite;
import com.github.stephengold.joltjni.MotionProperties;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.ConstBodyLockInterfaceLocking;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.xmx.velthoric.item.physicsgun.VxGrabbedBodyInfo;
import net.xmx.velthoric.item.physicsgun.manager.VxPhysicsGunClientManager;
import net.xmx.velthoric.item.physicsgun.packet.VxPhysicsGunSyncPacket;
import net.xmx.velthoric.network.VxPacketHandler;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.raycasting.VxHitResult;
import net.xmx.velthoric.physics.raycasting.VxRaycaster;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxPhysicsGunServerManager {
    private static final VxPhysicsGunServerManager INSTANCE = new VxPhysicsGunServerManager();
    private final Map<UUID, VxGrabbedBodyInfo> grabbedBodies = new ConcurrentHashMap<UUID, VxGrabbedBodyInfo>();
    private final Set<UUID> playersTryingToGrab = ConcurrentHashMap.newKeySet();
    private static final float MIN_DISTANCE = 2.0f;
    private static final float MAX_DISTANCE = 450.0f;

    private VxPhysicsGunServerManager() {
    }

    public static VxPhysicsGunServerManager getInstance() {
        return INSTANCE;
    }

    private static Quat playerRotToQuat(float pitch, float yaw) {
        Quat qPitch = Quat.sRotation(new Vec3(1.0f, 0.0f, 0.0f), (float)Math.toRadians(pitch));
        Quat qYaw = Quat.sRotation(new Vec3(0.0f, 1.0f, 0.0f), (float)Math.toRadians(-yaw));
        return Op.star((QuatArg)qYaw, (QuatArg)qPitch);
    }

    public void startGrabAttempt(class_3222 player) {
        if (this.isGrabbing((class_1657)player)) {
            return;
        }
        if (this.playersTryingToGrab.add(player.method_5667())) {
            this.syncStateWithClients();
        }
    }

    public void stopGrabAttempt(class_3222 player) {
        boolean changed = this.playersTryingToGrab.remove(player.method_5667());
        if (this.isGrabbing((class_1657)player)) {
            this.stopGrab(player);
        } else if (changed) {
            this.syncStateWithClients();
        }
    }

    public boolean isGrabbing(class_1657 player) {
        return this.grabbedBodies.containsKey(player.method_5667());
    }

    public Map<UUID, VxGrabbedBodyInfo> getGrabbedBodies() {
        return this.grabbedBodies;
    }

    public boolean isTryingToGrab(class_1657 player) {
        return this.playersTryingToGrab.contains(player.method_5667());
    }

    public Set<UUID> getPlayersTryingToGrab() {
        return this.playersTryingToGrab;
    }

    public void startRotationMode(class_3222 player) {
        this.grabbedBodies.computeIfPresent(player.method_5667(), (uuid, info) -> {
            Quat currentPlayerRotation = VxPhysicsGunServerManager.playerRotToQuat(player.method_36455(), player.method_36454());
            Quat playerRotationDelta = Op.star((QuatArg)currentPlayerRotation, (QuatArg)info.initialPlayerRotation().conjugated());
            Quat syncedBodyRotation = Op.star((QuatArg)playerRotationDelta, (QuatArg)info.initialBodyRotation());
            return new VxGrabbedBodyInfo(info.physicsId(), info.bodyId(), info.grabPointLocal(), info.currentDistance(), info.originalAngularDamping(), syncedBodyRotation, currentPlayerRotation, true);
        });
    }

    public void stopRotationMode(class_3222 player) {
        this.grabbedBodies.computeIfPresent(player.method_5667(), (uuid, info) -> new VxGrabbedBodyInfo(info.physicsId(), info.bodyId(), info.grabPointLocal(), info.currentDistance(), info.originalAngularDamping(), info.initialBodyRotation(), VxPhysicsGunServerManager.playerRotToQuat(player.method_36455(), player.method_36454()), false));
    }

    public void startGrab(class_3222 player) {
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)player.method_37908().method_27983());
        if (physicsWorld == null) {
            return;
        }
        class_243 eyePos = player.method_33571();
        class_243 lookVec = player.method_5720();
        class_1937 level = player.method_37908();
        physicsWorld.execute(() -> {
            RVec3 rayOrigin = new RVec3((float)eyePos.method_10216(), (float)eyePos.method_10214(), (float)eyePos.method_10215());
            Vec3 rayDirection = new Vec3((float)lookVec.method_10216(), (float)lookVec.method_10214(), (float)lookVec.method_10215());
            VxRaycaster.raycastPhysics(physicsWorld, rayOrigin, rayDirection, 450.0f).ifPresent(physicsHitResult -> {
                block16: {
                    VxHitResult.PhysicsHit physicsHit = physicsHitResult.getPhysicsHit().orElseThrow();
                    VxBody physicsBody = physicsWorld.getBodyManager().getByJoltBodyId(physicsHit.bodyId());
                    if (physicsBody == null) {
                        return;
                    }
                    UUID physicsId = physicsBody.getPhysicsId();
                    BodyInterface bodyInterface = physicsWorld.getPhysicsSystem().getBodyInterface();
                    if (bodyInterface == null) {
                        return;
                    }
                    bodyInterface.setMotionType(physicsHit.bodyId(), EMotionType.Dynamic, EActivation.Activate);
                    bodyInterface.activateBody(physicsHit.bodyId());
                    ConstBodyLockInterfaceLocking bodyLockInterface = physicsWorld.getPhysicsSystem().getBodyLockInterface();
                    if (bodyLockInterface == null) {
                        return;
                    }
                    try (BodyLockWrite lock = new BodyLockWrite(bodyLockInterface, physicsHit.bodyId());){
                        if (!lock.succeededAndIsInBroadPhase() || !lock.getBody().isDynamic()) break block16;
                        Body body = lock.getBody();
                        MotionProperties motionProperties = body.getMotionProperties();
                        if (motionProperties == null) {
                            return;
                        }
                        Vec3 offset = Op.star((Vec3Arg)rayDirection, physicsHit.hitFraction() * 450.0f);
                        RVec3 hitPointWorld = Op.plus((RVec3Arg)rayOrigin, (Vec3Arg)offset);
                        try (RMat44 invBodyTransform = body.getInverseCenterOfMassTransform();){
                            float originalDamping = motionProperties.getAngularDamping();
                            Vec3 hitPointLocal = Op.star((RMat44Arg)invBodyTransform, (RVec3Arg)hitPointWorld).toVec3();
                            float grabDistance = (float)Op.minus((RVec3Arg)rayOrigin, hitPointWorld).length();
                            Quat initialPlayerRot = VxPhysicsGunServerManager.playerRotToQuat(player.method_36455(), player.method_36454());
                            Quat initialBodyRot = body.getRotation();
                            VxGrabbedBodyInfo info = new VxGrabbedBodyInfo(physicsId, physicsHit.bodyId(), hitPointLocal, grabDistance, originalDamping, initialBodyRot, initialPlayerRot, false);
                            this.grabbedBodies.put(player.method_5667(), info);
                            this.playersTryingToGrab.remove(player.method_5667());
                            motionProperties.setAngularDamping(2.0f);
                            body.setAngularVelocity(new Vec3(0.0f, 0.0f, 0.0f));
                            this.syncStateWithClients();
                        }
                    }
                }
            });
        });
    }

    public void stopGrab(class_3222 player) {
        VxGrabbedBodyInfo info = this.grabbedBodies.remove(player.method_5667());
        if (info != null) {
            this.syncStateWithClients();
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)player.method_37908().method_27983());
            if (physicsWorld != null) {
                physicsWorld.execute(() -> {
                    BodyInterface bodyInterface = physicsWorld.getPhysicsSystem().getBodyInterface();
                    ConstBodyLockInterfaceLocking bodyLockInterface = physicsWorld.getPhysicsSystem().getBodyLockInterface();
                    if (bodyInterface != null && bodyLockInterface != null) {
                        try (BodyLockWrite lock = new BodyLockWrite(bodyLockInterface, info.bodyId());){
                            MotionProperties motionProperties;
                            if (lock.succeededAndIsInBroadPhase() && (motionProperties = lock.getBody().getMotionProperties()) != null) {
                                motionProperties.setAngularDamping(info.originalAngularDamping());
                            }
                        }
                        bodyInterface.activateBody(info.bodyId());
                    }
                });
            }
        }
    }

    public void freezeBody(class_3222 player) {
        VxGrabbedBodyInfo info = this.grabbedBodies.get(player.method_5667());
        if (info == null) {
            return;
        }
        this.stopGrab(player);
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)player.method_37908().method_27983());
        if (physicsWorld == null) {
            return;
        }
        physicsWorld.execute(() -> {
            BodyInterface bodyInterface = physicsWorld.getPhysicsSystem().getBodyInterface();
            if (bodyInterface != null) {
                bodyInterface.setMotionType(info.bodyId(), EMotionType.Static, EActivation.DontActivate);
            }
        });
    }

    public void updateScroll(class_3222 player, float scrollDelta) {
        this.grabbedBodies.computeIfPresent(player.method_5667(), (uuid, info) -> {
            float newDistance = info.currentDistance() + scrollDelta;
            newDistance = Math.max(2.0f, Math.min(450.0f, newDistance));
            return new VxGrabbedBodyInfo(info.physicsId(), info.bodyId(), info.grabPointLocal(), newDistance, info.originalAngularDamping(), info.initialBodyRotation(), info.initialPlayerRotation(), info.inRotationMode());
        });
    }

    public void updateRotation(class_3222 player, float deltaX, float deltaY) {
        this.grabbedBodies.computeIfPresent(player.method_5667(), (uuid, info) -> {
            class_243 worldUp;
            float SENSITIVITY = 0.003f;
            class_243 look = player.method_5720();
            class_243 right = look.method_1036(worldUp = new class_243(0.0, 1.0, 0.0)).method_1029();
            if (right.method_1027() < 1.0E-7) {
                float yawRad = (float)Math.toRadians(player.method_36454());
                right = new class_243(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
            }
            Vec3 joltUp = new Vec3(0.0f, 1.0f, 0.0f);
            Vec3 joltRight = new Vec3((float)right.field_1352, (float)right.field_1351, (float)right.field_1350);
            Quat rotYaw = Quat.sRotation(joltUp, deltaX * 0.003f);
            Quat rotPitch = Quat.sRotation(joltRight, deltaY * 0.003f);
            Quat manualRot = Op.star((QuatArg)rotYaw, (QuatArg)rotPitch);
            Quat newInitialBodyRotation = Op.star((QuatArg)manualRot, (QuatArg)info.initialBodyRotation());
            return new VxGrabbedBodyInfo(info.physicsId(), info.bodyId(), info.grabPointLocal(), info.currentDistance(), info.originalAngularDamping(), newInitialBodyRotation, info.initialPlayerRotation(), info.inRotationMode());
        });
    }

    public void serverTick(class_3222 player) {
        VxGrabbedBodyInfo info = this.grabbedBodies.get(player.method_5667());
        if (info == null) {
            return;
        }
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)player.method_37908().method_27983());
        if (physicsWorld == null) {
            this.stopGrab(player);
            return;
        }
        class_243 eyePos = player.method_33571();
        class_243 lookVec = player.method_5720();
        float P_GAIN_LINEAR = 250.0f;
        float D_GAIN_LINEAR = 25.0f;
        float P_GAIN_ANGULAR = 150.0f;
        float D_GAIN_ANGULAR = 15.0f;
        physicsWorld.execute(() -> {
            BodyInterface bodyInterface = physicsWorld.getPhysicsSystem().getBodyInterface();
            if (bodyInterface == null || !bodyInterface.isAdded(info.bodyId())) {
                return;
            }
            bodyInterface.activateBody(info.bodyId());
            ConstBodyLockInterfaceLocking bodyLockInterface = physicsWorld.getPhysicsSystem().getBodyLockInterface();
            if (bodyLockInterface == null) {
                return;
            }
            try (BodyLockWrite lock = new BodyLockWrite(bodyLockInterface, info.bodyId());){
                Quat targetBodyRotation;
                if (!lock.succeededAndIsInBroadPhase() || !lock.getBody().isDynamic()) {
                    this.grabbedBodies.remove(player.method_5667());
                    this.syncStateWithClients();
                    return;
                }
                Body body = lock.getBody();
                MotionProperties motionProperties = body.getMotionProperties();
                if (motionProperties == null || motionProperties.getInverseMass() == 0.0f) {
                    return;
                }
                float mass = 1.0f / motionProperties.getInverseMass();
                try (RMat44 comTransform = body.getCenterOfMassTransform();){
                    RVec3 targetPointWorld = new RVec3(eyePos.field_1352 + lookVec.field_1352 * (double)info.currentDistance(), eyePos.field_1351 + lookVec.field_1351 * (double)info.currentDistance(), eyePos.field_1350 + lookVec.field_1350 * (double)info.currentDistance());
                    RVec3 currentGrabPointWorld = Op.star((RMat44Arg)comTransform, (Vec3Arg)info.grabPointLocal());
                    RVec3 positionError = Op.minus((RVec3Arg)targetPointWorld, currentGrabPointWorld);
                    Vec3 currentVelocity = body.getLinearVelocity();
                    Vec3 desiredAcceleration = Op.minus(Op.star((Vec3Arg)positionError.toVec3(), 250.0f), (Vec3Arg)Op.star((Vec3Arg)currentVelocity, 25.0f));
                    Vec3 force = Op.star((Vec3Arg)desiredAcceleration, mass);
                    body.addForce(force);
                }
                if (info.inRotationMode()) {
                    targetBodyRotation = info.initialBodyRotation();
                } else {
                    Quat currentPlayerRotation = VxPhysicsGunServerManager.playerRotToQuat(player.method_36455(), player.method_36454());
                    Quat playerRotationDelta = Op.star((QuatArg)currentPlayerRotation, (QuatArg)info.initialPlayerRotation().conjugated());
                    targetBodyRotation = Op.star((QuatArg)playerRotationDelta, (QuatArg)info.initialBodyRotation());
                }
                Quat currentBodyRotation = body.getRotation();
                Quat errorQuat = Op.star((QuatArg)targetBodyRotation, (QuatArg)currentBodyRotation.conjugated());
                if (errorQuat.getW() < 0.0f) {
                    errorQuat.set(-errorQuat.getX(), -errorQuat.getY(), -errorQuat.getZ(), -errorQuat.getW());
                }
                Vec3 rotationError = new Vec3(errorQuat.getX(), errorQuat.getY(), errorQuat.getZ());
                Vec3 currentAngularVelocity = body.getAngularVelocity();
                Vec3 desiredAngularAccel = Op.minus(Op.star((Vec3Arg)rotationError, 150.0f), (Vec3Arg)Op.star((Vec3Arg)currentAngularVelocity, 15.0f));
                Quat invBodyRot = currentBodyRotation.conjugated();
                Vec3 desiredAngularAccelLocal = Op.star((QuatArg)invBodyRot, (Vec3Arg)desiredAngularAccel);
                Vec3 invInertiaDiag = motionProperties.getInverseInertiaDiagonal();
                float ix = invInertiaDiag.getX() == 0.0f ? 0.0f : 1.0f / invInertiaDiag.getX();
                float iy = invInertiaDiag.getY() == 0.0f ? 0.0f : 1.0f / invInertiaDiag.getY();
                float iz = invInertiaDiag.getZ() == 0.0f ? 0.0f : 1.0f / invInertiaDiag.getZ();
                Vec3 inertiaDiag = new Vec3(ix, iy, iz);
                Quat inertiaRotation = motionProperties.getInertiaRotation();
                Quat invInertiaRotation = inertiaRotation.conjugated();
                Vec3 accelInInertiaSpace = Op.star((QuatArg)invInertiaRotation, (Vec3Arg)desiredAngularAccelLocal);
                accelInInertiaSpace.setX(accelInInertiaSpace.getX() * inertiaDiag.getX());
                accelInInertiaSpace.setY(accelInInertiaSpace.getY() * inertiaDiag.getY());
                accelInInertiaSpace.setZ(accelInInertiaSpace.getZ() * inertiaDiag.getZ());
                Vec3 torqueInInertiaSpace = accelInInertiaSpace;
                Vec3 torqueLocal = Op.star((QuatArg)inertiaRotation, (Vec3Arg)torqueInInertiaSpace);
                Vec3 torqueWorld = Op.star((QuatArg)currentBodyRotation, (Vec3Arg)torqueLocal);
                body.addTorque(torqueWorld);
            }
        });
    }

    public void syncStateWithClients() {
        Map clientGrabData = this.grabbedBodies.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, entry -> {
            VxGrabbedBodyInfo info = (VxGrabbedBodyInfo)entry.getValue();
            class_243 localHitPoint = new class_243((double)info.grabPointLocal().getX(), (double)info.grabPointLocal().getY(), (double)info.grabPointLocal().getZ());
            return new VxPhysicsGunClientManager.ClientGrabData(info.physicsId(), localHitPoint);
        }));
        VxPacketHandler.sendToAll(new VxPhysicsGunSyncPacket(clientGrabData, this.playersTryingToGrab));
    }

    public void syncStateForNewPlayer(class_3222 player) {
        Map clientGrabData = this.grabbedBodies.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, entry -> {
            VxGrabbedBodyInfo info = (VxGrabbedBodyInfo)entry.getValue();
            class_243 localHitPoint = new class_243((double)info.grabPointLocal().getX(), (double)info.grabPointLocal().getY(), (double)info.grabPointLocal().getZ());
            return new VxPhysicsGunClientManager.ClientGrabData(info.physicsId(), localHitPoint);
        }));
        VxPacketHandler.sendToPlayer(new VxPhysicsGunSyncPacket(clientGrabData, this.playersTryingToGrab), player);
    }
}

