/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.xmx.velthoric.item.physicsgun.manager.VxPhysicsGunServerManager;

public class VxPhysicsGunActionPacket {
    private final ActionType actionType;
    private final float value1;
    private final float value2;

    public VxPhysicsGunActionPacket(ActionType actionType) {
        this(actionType, 0.0f, 0.0f);
    }

    public VxPhysicsGunActionPacket(float scrollDelta) {
        this(ActionType.UPDATE_SCROLL, scrollDelta, 0.0f);
    }

    public VxPhysicsGunActionPacket(float deltaX, float deltaY) {
        this(ActionType.UPDATE_ROTATION, deltaX, deltaY);
    }

    private VxPhysicsGunActionPacket(ActionType actionType, float value1, float value2) {
        this.actionType = actionType;
        this.value1 = value1;
        this.value2 = value2;
    }

    public static void encode(VxPhysicsGunActionPacket msg, class_2540 buf) {
        buf.method_10817((Enum)msg.actionType);
        if (msg.actionType == ActionType.UPDATE_SCROLL) {
            buf.writeFloat(msg.value1);
        } else if (msg.actionType == ActionType.UPDATE_ROTATION) {
            buf.writeFloat(msg.value1);
            buf.writeFloat(msg.value2);
        }
    }

    public static VxPhysicsGunActionPacket decode(class_2540 buf) {
        ActionType actionType = (ActionType)buf.method_10818(ActionType.class);
        float value1 = 0.0f;
        float value2 = 0.0f;
        if (actionType == ActionType.UPDATE_SCROLL) {
            value1 = buf.readFloat();
        } else if (actionType == ActionType.UPDATE_ROTATION) {
            value1 = buf.readFloat();
            value2 = buf.readFloat();
        }
        return new VxPhysicsGunActionPacket(actionType, value1, value2);
    }

    public static void handle(VxPhysicsGunActionPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            class_3222 player = (class_3222)context.getPlayer();
            if (player == null) {
                return;
            }
            VxPhysicsGunServerManager manager = VxPhysicsGunServerManager.getInstance();
            switch (msg.actionType) {
                case START_GRAB_ATTEMPT: {
                    manager.startGrabAttempt(player);
                    break;
                }
                case STOP_GRAB_ATTEMPT: {
                    manager.stopGrabAttempt(player);
                    break;
                }
                case UPDATE_SCROLL: {
                    manager.updateScroll(player, msg.value1);
                    break;
                }
                case UPDATE_ROTATION: {
                    manager.updateRotation(player, msg.value1, msg.value2);
                    break;
                }
                case FREEZE_OBJECT: {
                    manager.freezeBody(player);
                    break;
                }
                case START_ROTATION_MODE: {
                    manager.startRotationMode(player);
                    break;
                }
                case STOP_ROTATION_MODE: {
                    manager.stopRotationMode(player);
                }
            }
        });
    }

    public static enum ActionType {
        START_GRAB_ATTEMPT,
        STOP_GRAB_ATTEMPT,
        UPDATE_SCROLL,
        UPDATE_ROTATION,
        FREEZE_OBJECT,
        START_ROTATION_MODE,
        STOP_ROTATION_MODE;

    }
}

