/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.packet;

import dev.architectury.networking.NetworkManager;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.xmx.velthoric.item.physicsgun.manager.VxPhysicsGunClientManager;

public class VxPhysicsGunSyncPacket {
    private final Map<UUID, VxPhysicsGunClientManager.ClientGrabData> activeGrabs;
    private final Set<UUID> playersTryingToGrab;

    public VxPhysicsGunSyncPacket(Map<UUID, VxPhysicsGunClientManager.ClientGrabData> activeGrabs, Set<UUID> playersTryingToGrab) {
        this.activeGrabs = activeGrabs;
        this.playersTryingToGrab = playersTryingToGrab;
    }

    public static void encode(VxPhysicsGunSyncPacket msg, class_2540 buf) {
        buf.method_10804(msg.activeGrabs.size());
        for (Map.Entry<UUID, VxPhysicsGunClientManager.ClientGrabData> entry : msg.activeGrabs.entrySet()) {
            buf.method_10797(entry.getKey());
            VxPhysicsGunClientManager.ClientGrabData data = entry.getValue();
            buf.method_10797(data.objectUuid());
            buf.writeDouble(data.localHitPoint().method_10216());
            buf.writeDouble(data.localHitPoint().method_10214());
            buf.writeDouble(data.localHitPoint().method_10215());
        }
        buf.method_10804(msg.playersTryingToGrab.size());
        for (UUID uuid : msg.playersTryingToGrab) {
            buf.method_10797(uuid);
        }
    }

    public static VxPhysicsGunSyncPacket decode(class_2540 buf) {
        int grabsSize = buf.method_10816();
        ConcurrentHashMap<UUID, VxPhysicsGunClientManager.ClientGrabData> activeGrabs = new ConcurrentHashMap<UUID, VxPhysicsGunClientManager.ClientGrabData>();
        for (int i2 = 0; i2 < grabsSize; ++i2) {
            UUID playerUuid = buf.method_10790();
            UUID objectUuid = buf.method_10790();
            class_243 localHitPoint = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            activeGrabs.put(playerUuid, new VxPhysicsGunClientManager.ClientGrabData(objectUuid, localHitPoint));
        }
        int tryingSize = buf.method_10816();
        Set<UUID> playersTryingToGrab = IntStream.range(0, tryingSize).mapToObj(i -> buf.method_10790()).collect(Collectors.toSet());
        return new VxPhysicsGunSyncPacket(activeGrabs, playersTryingToGrab);
    }

    public static void handle(VxPhysicsGunSyncPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> VxPhysicsGunClientManager.getInstance().updateState(msg.activeGrabs, msg.playersTryingToGrab));
    }
}

