/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.entity;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyInterpolator;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class MixinEntity {
    @Shadow
    private class_1937 field_6002;
    @Unique
    private static final RVec3 velthoric_interpolatedPosition = new RVec3();
    @Unique
    private static final Quat velthoric_interpolatedRotation = new Quat();

    @Shadow
    public abstract float method_5751();

    @Shadow
    public abstract class_1297 method_5854();

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void velthoric_getEyePositionOnPhysicsBody(float partialTicks, CallbackInfoReturnable<class_243> cir) {
        if (!this.field_6002.method_8608()) {
            return;
        }
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof VxMountingEntity) {
            VxMountingEntity proxy = (VxMountingEntity)class_12972;
            proxy.getPhysicsBodyId().ifPresent(id -> {
                VxClientBodyManager manager = VxClientBodyManager.getInstance();
                VxClientBodyDataStore store = manager.getStore();
                VxClientBodyInterpolator interpolator = manager.getInterpolator();
                Integer index = store.getIndexForId((UUID)id);
                if (index == null || !store.render_isInitialized[index]) {
                    return;
                }
                interpolator.interpolateFrame(store, index, partialTicks, velthoric_interpolatedPosition, velthoric_interpolatedRotation);
                Quaterniond physRotation = new Quaterniond((double)velthoric_interpolatedRotation.getX(), (double)velthoric_interpolatedRotation.getY(), (double)velthoric_interpolatedRotation.getZ(), (double)velthoric_interpolatedRotation.getW());
                Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
                physRotation.transform(rideOffset);
                Vector3d playerBasePos = new Vector3d(velthoric_interpolatedPosition.xx(), velthoric_interpolatedPosition.yy(), velthoric_interpolatedPosition.zz()).add((double)rideOffset.x(), (double)rideOffset.y(), (double)rideOffset.z());
                Vector3d eyeOffset = new Vector3d(0.0, (double)this.method_5751(), 0.0);
                physRotation.transform(eyeOffset);
                Vector3d finalEyePos = playerBasePos.add((Vector3dc)eyeOffset);
                cir.setReturnValue((Object)new class_243(finalEyePos.x, finalEyePos.y, finalEyePos.z));
            });
        }
    }

    @Inject(method={"calculateViewVector(FF)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void velthoric_transformViewVector(float xRot, float yRot, CallbackInfoReturnable<class_243> cir) {
        class_1297 self = (class_1297)this;
        class_1297 class_12972 = self.method_5854();
        if (!(class_12972 instanceof VxMountingEntity)) {
            return;
        }
        VxMountingEntity proxy = (VxMountingEntity)class_12972;
        proxy.getPhysicsBodyId().ifPresent(id -> {
            Quaterniond vehicleRotation;
            class_243 localViewVector = (class_243)cir.getReturnValue();
            Vector3d transformedVector = new Vector3d(localViewVector.field_1352, localViewVector.field_1351, localViewVector.field_1350);
            if (this.field_6002.method_8608()) {
                vehicleRotation = this.velthoric_getClientRotation((UUID)id);
                if (vehicleRotation == null) {
                    return;
                }
            } else {
                VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)this.field_6002.method_27983());
                if (physicsWorld == null) {
                    return;
                }
                VxBody body = physicsWorld.getBodyManager().getVxBody((UUID)id);
                if (body == null) {
                    return;
                }
                Quat rot = body.getTransform().getRotation();
                vehicleRotation = new Quaterniond((double)rot.getX(), (double)rot.getY(), (double)rot.getZ(), (double)rot.getW());
            }
            vehicleRotation.transform(transformedVector);
            cir.setReturnValue((Object)new class_243(transformedVector.x, transformedVector.y, transformedVector.z));
        });
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    private Quaterniond velthoric_getClientRotation(UUID id) {
        VxClientBodyManager manager = VxClientBodyManager.getInstance();
        VxClientBodyDataStore store = manager.getStore();
        Integer index = store.getIndexForId(id);
        if (index == null || !store.render_isInitialized[index]) {
            return null;
        }
        float partialTicks = this.velthoric_getPartialTicksClient();
        manager.getInterpolator().interpolateRotation(store, index, partialTicks, velthoric_interpolatedRotation);
        return new Quaterniond((double)velthoric_interpolatedRotation.getX(), (double)velthoric_interpolatedRotation.getY(), (double)velthoric_interpolatedRotation.getZ(), (double)velthoric_interpolatedRotation.getW());
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    private float velthoric_getPartialTicksClient() {
        return class_310.method_1551().method_1488();
    }
}

