/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.network;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class VxPacketUtils {
    private static final ThreadLocal<Deflater> DEFLATER = ThreadLocal.withInitial(Deflater::new);
    private static final ThreadLocal<Inflater> INFLATER = ThreadLocal.withInitial(Inflater::new);
    private static final ThreadLocal<ByteArrayOutputStream> OUTPUT_STREAM = ThreadLocal.withInitial(ByteArrayOutputStream::new);
    private static final ThreadLocal<byte[]> BUFFER = ThreadLocal.withInitial(() -> new byte[8192]);

    public static byte[] compress(byte[] data) throws IOException {
        Deflater deflater = DEFLATER.get();
        ByteArrayOutputStream outputStream = OUTPUT_STREAM.get();
        byte[] buffer = BUFFER.get();
        deflater.reset();
        outputStream.reset();
        deflater.setInput(data);
        deflater.finish();
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        return outputStream.toByteArray();
    }

    public static byte[] decompress(byte[] data) throws IOException, DataFormatException {
        Inflater inflater = INFLATER.get();
        ByteArrayOutputStream outputStream = OUTPUT_STREAM.get();
        byte[] buffer = BUFFER.get();
        inflater.reset();
        outputStream.reset();
        inflater.setInput(data);
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        return outputStream.toByteArray();
    }
}

