/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.client;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import dev.architectury.event.events.client.ClientTickEvent;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.xmx.velthoric.event.api.VxClientPlayerNetworkEvent;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyInterpolator;
import net.xmx.velthoric.physics.body.client.time.VxClientClock;
import net.xmx.velthoric.physics.body.registry.VxBodyRegistry;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.VxMountable;
import net.xmx.velthoric.physics.mounting.manager.VxClientMountingManager;
import net.xmx.velthoric.physics.mounting.seat.VxSeat;
import org.jetbrains.annotations.Nullable;

public class VxClientBodyManager {
    private static final VxClientBodyManager INSTANCE = new VxClientBodyManager();
    private static final long INTERPOLATION_DELAY_NANOS = 150000000L;
    private final VxClientBodyDataStore store = new VxClientBodyDataStore();
    private final VxClientBodyInterpolator interpolator = new VxClientBodyInterpolator();
    private final VxClientClock clock = VxClientClock.getInstance();
    private final Map<UUID, VxBody> managedBodies = new ConcurrentHashMap<UUID, VxBody>();
    private long clockOffsetNanos = 0L;
    private boolean isClockOffsetInitialized = false;
    private final List<Long> clockOffsetSamples = new ArrayList<Long>();

    private VxClientBodyManager() {
    }

    public static VxClientBodyManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClockSyncSample(long offsetSample) {
        List<Long> list = this.clockOffsetSamples;
        synchronized (list) {
            this.clockOffsetSamples.add(offsetSample);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeClock() {
        List<Long> list = this.clockOffsetSamples;
        synchronized (list) {
            if (this.clockOffsetSamples.size() < 20) {
                return;
            }
            Collections.sort(this.clockOffsetSamples);
            int trimCount = this.clockOffsetSamples.size() / 4;
            List<Long> trimmedSamples = this.clockOffsetSamples.subList(trimCount, this.clockOffsetSamples.size() - trimCount);
            if (trimmedSamples.isEmpty()) {
                this.clockOffsetSamples.clear();
                return;
            }
            long sum = 0L;
            for (Long sample : trimmedSamples) {
                sum += sample.longValue();
            }
            long averageOffset = sum / (long)trimmedSamples.size();
            this.clockOffsetSamples.clear();
            if (!this.isClockOffsetInitialized) {
                this.clockOffsetNanos = averageOffset;
                this.isClockOffsetInitialized = true;
            } else {
                this.clockOffsetNanos = (long)((double)this.clockOffsetNanos * 0.95 + (double)averageOffset * 0.05);
            }
        }
    }

    public void spawnBody(UUID id, class_2960 typeId, VxByteBuf data, long timestamp) {
        VxMountable mountable;
        List<VxSeat> seats;
        if (this.store.hasBody(id)) {
            VxMainClass.LOGGER.warn("Client received spawn request for already existing body: {}", (Object)id);
            return;
        }
        VxBodyRegistry registry = VxBodyRegistry.getInstance();
        VxBodyType<?> type = registry.getRegistrationData(typeId);
        if (type == null) {
            VxMainClass.LOGGER.error("Could not spawn client body with type ID '{}', type not registered on client.", (Object)typeId);
            return;
        }
        VxBody body = registry.createClientBody(type, id);
        if (body == null) {
            return;
        }
        if (body instanceof VxMountable && (seats = (mountable = (VxMountable)((Object)body)).defineSeats()) != null) {
            for (VxSeat seat : seats) {
                VxClientMountingManager.INSTANCE.addSeat(id, seat);
            }
        }
        int index = this.store.addBody(id);
        body.setDataStoreIndex(index);
        this.managedBodies.put(id, body);
        VxTransform transform = new VxTransform();
        transform.fromBuffer(data);
        body.getSynchronizedData().readEntries(data, body);
        this.initializeState(index, transform, timestamp);
    }

    private void initializeState(int index, VxTransform transform, long timestamp) {
        RVec3 pos = transform.getTranslation();
        Quat rot = transform.getRotation();
        this.store.state0_timestamp[index] = timestamp;
        this.store.state1_timestamp[index] = timestamp;
        this.store.state0_posX[index] = this.store.state1_posX[index] = pos.x();
        this.store.state0_posY[index] = this.store.state1_posY[index] = pos.y();
        this.store.state0_posZ[index] = this.store.state1_posZ[index] = pos.z();
        this.store.state0_rotX[index] = this.store.state1_rotX[index] = rot.getX();
        this.store.state0_rotY[index] = this.store.state1_rotY[index] = rot.getY();
        this.store.state0_rotZ[index] = this.store.state1_rotZ[index] = rot.getZ();
        this.store.state0_rotW[index] = this.store.state1_rotW[index] = rot.getW();
        this.store.state1_isActive[index] = true;
        this.store.state0_isActive[index] = true;
        this.store.render_posX[index] = pos.x();
        this.store.render_posY[index] = pos.y();
        this.store.render_posZ[index] = pos.z();
        this.store.render_rotX[index] = rot.getX();
        this.store.render_rotY[index] = rot.getY();
        this.store.render_rotZ[index] = rot.getZ();
        this.store.render_rotW[index] = rot.getW();
        this.store.prev_posX[index] = pos.x();
        this.store.prev_posY[index] = pos.y();
        this.store.prev_posZ[index] = pos.z();
        this.store.prev_rotX[index] = rot.getX();
        this.store.prev_rotY[index] = rot.getY();
        this.store.prev_rotZ[index] = rot.getZ();
        this.store.prev_rotW[index] = rot.getW();
        this.store.render_isInitialized[index] = true;
        if (this.store.lastKnownPosition[index] == null) {
            this.store.lastKnownPosition[index] = new RVec3();
        }
        this.store.lastKnownPosition[index].set(pos);
    }

    public void removeBody(UUID id) {
        this.managedBodies.remove(id);
        this.store.removeBody(id);
        VxClientMountingManager.INSTANCE.removeSeatsForBody(id);
    }

    public void updateSynchronizedData(UUID id, ByteBuf data) {
        VxBody body = this.managedBodies.get(id);
        if (body != null) {
            try {
                body.getSynchronizedData().readEntries(new VxByteBuf(data), body);
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Failed to read synchronized data for body {}", (Object)id, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        this.store.clear();
        this.managedBodies.clear();
        this.isClockOffsetInitialized = false;
        this.clockOffsetNanos = 0L;
        List<Long> list = this.clockOffsetSamples;
        synchronized (list) {
            this.clockOffsetSamples.clear();
        }
    }

    public void clientTick() {
        this.synchronizeClock();
        if (this.isClockOffsetInitialized) {
            long renderTimestamp = this.clock.getGameTimeNanos() + this.clockOffsetNanos - 150000000L;
            this.interpolator.updateInterpolationTargets(this.store, renderTimestamp);
        }
    }

    public static void registerEvents() {
        ClientTickEvent.CLIENT_PRE.register(client -> INSTANCE.clientTick());
        VxClientPlayerNetworkEvent.LoggingOut.EVENT.register(event -> INSTANCE.clearAll());
    }

    public VxClientBodyDataStore getStore() {
        return this.store;
    }

    public VxClientBodyInterpolator getInterpolator() {
        return this.interpolator;
    }

    public Collection<VxBody> getAllBodies() {
        return this.managedBodies.values();
    }

    public VxClientClock getClock() {
        return this.clock;
    }

    @Nullable
    public VxBody getBody(UUID id) {
        return this.managedBodies.get(id);
    }
}

