/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.client.renderer;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_761;
import net.xmx.velthoric.event.api.VxRenderEvent;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.mixin.impl.debug.EntityRenderDispatcherAccessor;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxBodyRenderer;
import net.xmx.velthoric.physics.body.client.renderer.VxDebugRenderer;
import net.xmx.velthoric.physics.body.registry.VxBodyRegistry;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.body.type.VxSoftBody;
import org.joml.Matrix4f;

public class VxPhysicsRenderer {
    private static final float CULLING_BOUNDS_INFLATION = 2.0f;
    private static final VxRenderState finalRenderState = new VxRenderState();
    private static final RVec3 interpolatedPosition = new RVec3();
    private static final Quat interpolatedRotation = new Quat();
    private static final VxDebugRenderer debugRenderer = new VxDebugRenderer();

    public static void registerEvents() {
        VxRenderEvent.ClientRenderLevelStageEvent.EVENT.register(VxPhysicsRenderer::onRenderLevelStage);
    }

    private static void onRenderLevelStage(VxRenderEvent.ClientRenderLevelStageEvent event) {
        if (event.getStage() != VxRenderEvent.ClientRenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.method_1560() == null) {
            return;
        }
        VxClientBodyManager manager = VxClientBodyManager.getInstance();
        if (manager.getAllBodies().isEmpty()) {
            return;
        }
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        class_4587 poseStack = event.getPoseStack();
        float partialTicks = event.getPartialTick();
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        Matrix4f projectionMatrix = event.getProjectionMatrix();
        class_4604 frustum = new class_4604(poseStack.method_23760().method_23761(), projectionMatrix);
        frustum.method_23088(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        for (VxBody body : manager.getAllBodies()) {
            try {
                int packedLight;
                class_238 objectAABB;
                if (!body.isInitialized() || !frustum.method_23093(objectAABB = body.getCullingAABB(2.0f))) continue;
                body.calculateRenderState(partialTicks, finalRenderState, interpolatedPosition, interpolatedRotation);
                if (body instanceof VxSoftBody && VxPhysicsRenderer.finalRenderState.vertexData != null && VxPhysicsRenderer.finalRenderState.vertexData.length >= 3) {
                    packedLight = class_761.method_23794((class_1920)mc.field_1687, (class_2338)class_2338.method_49637((double)VxPhysicsRenderer.finalRenderState.vertexData[0], (double)VxPhysicsRenderer.finalRenderState.vertexData[1], (double)VxPhysicsRenderer.finalRenderState.vertexData[2]));
                } else {
                    RVec3 renderPosition = VxPhysicsRenderer.finalRenderState.transform.getTranslation();
                    packedLight = class_761.method_23794((class_1920)mc.field_1687, (class_2338)class_2338.method_49637((double)renderPosition.xx(), (double)renderPosition.yy(), (double)renderPosition.zz()));
                }
                VxPhysicsRenderer.renderBody(body, poseStack, bufferSource, partialTicks, packedLight, finalRenderState);
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Error rendering physics body {}", (Object)body.getPhysicsId(), (Object)e);
            }
        }
        if (((EntityRenderDispatcherAccessor)mc.method_1561()).getRenderHitBoxes()) {
            debugRenderer.render(poseStack, (class_4597)bufferSource, manager, partialTicks);
        }
        poseStack.method_22909();
        bufferSource.method_22993();
    }

    private static void renderBody(VxBody body, class_4587 poseStack, class_4597.class_4598 bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        class_2960 typeId = body.getTypeId();
        VxBodyRenderer<?> renderer = VxBodyRegistry.getInstance().getClientRenderer(typeId);
        if (renderer != null) {
            renderer.render(body, poseStack, bufferSource, partialTicks, packedLight, renderState);
        } else {
            VxMainClass.LOGGER.warn("No renderer registered for physics body type: {}", (Object)typeId);
        }
    }
}

