/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.manager;

import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.xmx.velthoric.physics.body.AbstractDataStore;
import org.jetbrains.annotations.Nullable;

public class VxBodyDataStore
extends AbstractDataStore {
    private static final int INITIAL_CAPACITY = 256;
    private final Map<UUID, Integer> uuidToIndex = new HashMap<UUID, Integer>();
    private final List<UUID> indexToUuid = new ArrayList<UUID>();
    private final Deque<Integer> freeIndices = new ArrayDeque<Integer>();
    private int count = 0;
    private int capacity = 0;
    public float[] posX;
    public float[] posY;
    public float[] posZ;
    public float[] rotX;
    public float[] rotY;
    public float[] rotZ;
    public float[] rotW;
    public float[] velX;
    public float[] velY;
    public float[] velZ;
    public float[] angVelX;
    public float[] angVelY;
    public float[] angVelZ;
    public float[] aabbMinX;
    public float[] aabbMinY;
    public float[] aabbMinZ;
    public float[] aabbMaxX;
    public float[] aabbMaxY;
    public float[] aabbMaxZ;
    public float[] @Nullable [] vertexData;
    public boolean[] isActive;
    public EBodyType[] bodyType;
    public EMotionType[] motionType;
    public long[] chunkKey;
    public boolean[] isGameStateDirty;
    public boolean[] isTransformDirty;
    public boolean[] isVertexDataDirty;
    public boolean[] isCustomDataDirty;
    public long[] lastUpdateTimestamp;

    public VxBodyDataStore() {
        this.allocate(256);
    }

    private void allocate(int newCapacity) {
        this.posX = this.grow(this.posX, newCapacity);
        this.posY = this.grow(this.posY, newCapacity);
        this.posZ = this.grow(this.posZ, newCapacity);
        this.rotX = this.grow(this.rotX, newCapacity);
        this.rotY = this.grow(this.rotY, newCapacity);
        this.rotZ = this.grow(this.rotZ, newCapacity);
        this.rotW = this.grow(this.rotW, newCapacity);
        this.velX = this.grow(this.velX, newCapacity);
        this.velY = this.grow(this.velY, newCapacity);
        this.velZ = this.grow(this.velZ, newCapacity);
        this.angVelX = this.grow(this.angVelX, newCapacity);
        this.angVelY = this.grow(this.angVelY, newCapacity);
        this.angVelZ = this.grow(this.angVelZ, newCapacity);
        this.aabbMinX = this.grow(this.aabbMinX, newCapacity);
        this.aabbMinY = this.grow(this.aabbMinY, newCapacity);
        this.aabbMinZ = this.grow(this.aabbMinZ, newCapacity);
        this.aabbMaxX = this.grow(this.aabbMaxX, newCapacity);
        this.aabbMaxY = this.grow(this.aabbMaxY, newCapacity);
        this.aabbMaxZ = this.grow(this.aabbMaxZ, newCapacity);
        this.vertexData = this.grow(this.vertexData, newCapacity);
        this.isActive = this.grow(this.isActive, newCapacity);
        this.bodyType = this.grow(this.bodyType, newCapacity);
        this.motionType = this.grow(this.motionType, newCapacity);
        this.chunkKey = this.grow(this.chunkKey, newCapacity);
        this.isGameStateDirty = this.grow(this.isGameStateDirty, newCapacity);
        this.isTransformDirty = this.grow(this.isTransformDirty, newCapacity);
        this.isVertexDataDirty = this.grow(this.isVertexDataDirty, newCapacity);
        this.isCustomDataDirty = this.grow(this.isCustomDataDirty, newCapacity);
        this.lastUpdateTimestamp = this.grow(this.lastUpdateTimestamp, newCapacity);
        this.capacity = newCapacity;
    }

    public synchronized int addBody(UUID id, EBodyType type) {
        int n;
        if (this.uuidToIndex.containsKey(id)) {
            return this.uuidToIndex.get(id);
        }
        if (this.count == this.capacity) {
            this.allocate(this.capacity * 2);
        }
        if (this.freeIndices.isEmpty()) {
            int n2 = this.count;
            n = n2;
            this.count = n2 + 1;
        } else {
            n = this.freeIndices.pop();
        }
        int index = n;
        this.uuidToIndex.put(id, index);
        if (index >= this.indexToUuid.size()) {
            this.indexToUuid.add(id);
        } else {
            this.indexToUuid.set(index, id);
        }
        this.bodyType[index] = type;
        this.chunkKey[index] = Long.MAX_VALUE;
        return index;
    }

    @Nullable
    public synchronized Integer removeBody(UUID id) {
        Integer index = this.uuidToIndex.remove(id);
        if (index != null) {
            this.resetIndex(index);
            this.freeIndices.push(index);
            this.indexToUuid.set(index, null);
            return index;
        }
        return null;
    }

    public synchronized void clear() {
        this.uuidToIndex.clear();
        this.indexToUuid.clear();
        this.freeIndices.clear();
        this.count = 0;
        this.allocate(256);
    }

    @Nullable
    public synchronized Integer getIndexForId(UUID id) {
        return this.uuidToIndex.get(id);
    }

    @Nullable
    public synchronized UUID getIdForIndex(int index) {
        if (index < 0 || index >= this.indexToUuid.size()) {
            return null;
        }
        return this.indexToUuid.get(index);
    }

    public synchronized int getBodyCount() {
        return this.count - this.freeIndices.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    private void resetIndex(int index) {
        this.posZ[index] = 0.0f;
        this.posY[index] = 0.0f;
        this.posX[index] = 0.0f;
        this.rotZ[index] = 0.0f;
        this.rotY[index] = 0.0f;
        this.rotX[index] = 0.0f;
        this.rotW[index] = 1.0f;
        this.velZ[index] = 0.0f;
        this.velY[index] = 0.0f;
        this.velX[index] = 0.0f;
        this.angVelZ[index] = 0.0f;
        this.angVelY[index] = 0.0f;
        this.angVelX[index] = 0.0f;
        this.aabbMinZ[index] = 0.0f;
        this.aabbMinY[index] = 0.0f;
        this.aabbMinX[index] = 0.0f;
        this.aabbMaxZ[index] = 0.0f;
        this.aabbMaxY[index] = 0.0f;
        this.aabbMaxX[index] = 0.0f;
        this.vertexData[index] = null;
        this.isActive[index] = false;
        this.bodyType[index] = null;
        this.motionType[index] = null;
        this.chunkKey[index] = Long.MAX_VALUE;
        this.isGameStateDirty[index] = false;
        this.isTransformDirty[index] = false;
        this.isVertexDataDirty[index] = false;
        this.isCustomDataDirty[index] = false;
        this.lastUpdateTimestamp[index] = 0L;
    }
}

