/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.DataFormatException;
import net.minecraft.class_2540;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.packet.VxSpawnData;

public class S2CSpawnBodyBatchPacket {
    private final List<VxSpawnData> spawnDataList;

    public S2CSpawnBodyBatchPacket(List<VxSpawnData> spawnDataList) {
        this.spawnDataList = spawnDataList;
    }

    public S2CSpawnBodyBatchPacket(class_2540 buf) {
        byte[] compressedData = buf.method_10795();
        try {
            byte[] decompressedData = VxPacketUtils.decompress(compressedData);
            class_2540 decompressedBuf = new class_2540(Unpooled.wrappedBuffer((byte[])decompressedData));
            int size = decompressedBuf.method_10816();
            this.spawnDataList = new ObjectArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.spawnDataList.add(new VxSpawnData(decompressedBuf));
            }
        }
        catch (IOException | DataFormatException e) {
            throw new IllegalStateException("Failed to decompress spawn body batch packet", e);
        }
    }

    public void encode(class_2540 buf) {
        class_2540 tempBuf = new class_2540(Unpooled.buffer());
        try {
            tempBuf.method_10804(this.spawnDataList.size());
            for (VxSpawnData data : this.spawnDataList) {
                data.encode(tempBuf);
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.method_10813(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress spawn body batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static void handle(S2CSpawnBodyBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            for (VxSpawnData data : msg.spawnDataList) {
                VxByteBuf dataBuf = new VxByteBuf(Unpooled.wrappedBuffer((byte[])data.data));
                try {
                    manager.spawnBody(data.id, data.typeIdentifier, dataBuf, data.timestamp);
                }
                finally {
                    if (dataBuf.refCnt() <= 0) continue;
                    dataBuf.release();
                }
            }
        });
    }
}

