/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.type;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.manager.VxRemovalReason;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxSynchronizedData;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public abstract class VxBody {
    protected final UUID physicsId;
    protected final VxSynchronizedData synchronizedData;
    protected final VxBodyType<? extends VxBody> type;
    private int bodyId = 0;
    private int dataStoreIndex = -1;
    protected final VxPhysicsWorld physicsWorld;

    protected VxBody(VxBodyType<? extends VxBody> type, VxPhysicsWorld physicsWorld, UUID id) {
        this.type = type;
        this.physicsWorld = physicsWorld;
        this.physicsId = id;
        this.synchronizedData = new VxSynchronizedData(EnvType.SERVER);
        this.defineSyncData();
    }

    @Environment(value=EnvType.CLIENT)
    protected VxBody(VxBodyType<? extends VxBody> type, UUID id) {
        this.type = type;
        this.physicsId = id;
        this.synchronizedData = new VxSynchronizedData(EnvType.CLIENT);
        this.defineSyncData();
        this.physicsWorld = null;
    }

    public void onBodyAdded(VxPhysicsWorld world) {
    }

    public void onBodyRemoved(VxPhysicsWorld world, VxRemovalReason reason) {
    }

    public void physicsTick(VxPhysicsWorld world) {
    }

    public void gameTick(class_3218 level) {
    }

    protected abstract void defineSyncData();

    public <T> T getSyncData(VxDataAccessor<T> accessor) {
        return this.synchronizedData.get(accessor);
    }

    public <T> void setSyncData(VxDataAccessor<T> accessor, T value) {
        if (this.physicsWorld == null) {
            return;
        }
        this.synchronizedData.set(accessor, value);
        if (this.synchronizedData.isDirty()) {
            this.physicsWorld.getBodyManager().markCustomDataDirty(this);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void onSyncedDataUpdated(VxDataAccessor<?> accessor) {
    }

    public void writeInitialSyncData(VxByteBuf buf) {
        List<VxSynchronizedData.Entry<?>> allEntries = this.synchronizedData.getAllEntries();
        VxSynchronizedData.writeEntries(buf, allEntries);
    }

    public boolean writeDirtySyncData(VxByteBuf buf) {
        List<VxSynchronizedData.Entry<?>> dirtyEntries = this.synchronizedData.getDirtyEntries();
        if (dirtyEntries == null) {
            return false;
        }
        VxSynchronizedData.writeEntries(buf, dirtyEntries);
        this.synchronizedData.clearDirty();
        return true;
    }

    public void writePersistenceData(VxByteBuf buf) {
    }

    public void readPersistenceData(VxByteBuf buf) {
    }

    public void getTransform(VxTransform outTransform) {
        if (this.physicsWorld != null && this.dataStoreIndex != -1) {
            this.physicsWorld.getBodyManager().getTransform(this.dataStoreIndex, outTransform);
        }
    }

    public VxTransform getTransform() {
        if (this.physicsWorld != null && this.dataStoreIndex != -1) {
            VxTransform transform = new VxTransform();
            this.physicsWorld.getBodyManager().getTransform(this.dataStoreIndex, transform);
            return transform;
        }
        return new VxTransform();
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void calculateRenderState(float var1, VxRenderState var2, RVec3 var3, Quat var4);

    @Environment(value=EnvType.CLIENT)
    public class_238 getCullingAABB(float inflation) {
        RVec3 lastPos = VxClientBodyManager.getInstance().getStore().lastKnownPosition[this.dataStoreIndex];
        return new class_238(lastPos.xx() - (double)inflation, lastPos.yy() - (double)inflation, lastPos.zz() - (double)inflation, lastPos.xx() + (double)inflation, lastPos.yy() + (double)inflation, lastPos.zz() + (double)inflation);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isInitialized() {
        return VxClientBodyManager.getInstance().getStore().render_isInitialized[this.dataStoreIndex];
    }

    public UUID getPhysicsId() {
        return this.physicsId;
    }

    public VxBodyType<? extends VxBody> getType() {
        return this.type;
    }

    public class_2960 getTypeId() {
        return this.type.getTypeId();
    }

    @Nullable
    public VxPhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    public VxSynchronizedData getSynchronizedData() {
        return this.synchronizedData;
    }

    public int getBodyId() {
        return this.bodyId;
    }

    public void setBodyId(int bodyId) {
        this.bodyId = bodyId;
    }

    public int getDataStoreIndex() {
        return this.dataStoreIndex;
    }

    public void setDataStoreIndex(int dataStoreIndex) {
        this.dataStoreIndex = dataStoreIndex;
    }
}

