/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.buoyancy;

import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.buoyancy.VxBuoyancyDataStore;
import net.xmx.velthoric.physics.buoyancy.VxFluidType;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxBuoyancyBroadPhase {
    private final VxPhysicsWorld physicsWorld;
    private final class_3218 level;

    public VxBuoyancyBroadPhase(VxPhysicsWorld physicsWorld) {
        this.physicsWorld = physicsWorld;
        this.level = physicsWorld.getLevel();
    }

    public void findPotentialFluidContacts(VxBuoyancyDataStore dataStore) {
        VxBodyDataStore ds = this.physicsWorld.getBodyManager().getDataStore();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int i = 0; i < ds.getCapacity(); ++i) {
            VxBody vxBody;
            float averageSurfaceHeight;
            UUID id;
            if (ds.motionType[i] == EMotionType.Static || (id = ds.getIdForIndex(i)) == null) continue;
            float minX = ds.aabbMinX[i];
            float minY = ds.aabbMinY[i];
            float minZ = ds.aabbMinZ[i];
            float maxX = ds.aabbMaxX[i];
            float maxY = ds.aabbMaxY[i];
            float maxZ = ds.aabbMaxZ[i];
            if (minX >= maxX || minY >= maxY || minZ >= maxZ) continue;
            float totalSurfaceHeight = 0.0f;
            int fluidColumnCount = 0;
            VxFluidType detectedType = null;
            int minBlockX = (int)Math.floor(minX);
            int maxBlockX = (int)Math.floor(maxX);
            int minBlockY = (int)Math.floor(minY);
            int maxBlockY = (int)Math.floor(maxY);
            int minBlockZ = (int)Math.floor(minZ);
            int maxBlockZ = (int)Math.floor(maxZ);
            for (int x = minBlockX; x <= maxBlockX; ++x) {
                block2: for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                    for (int y = maxBlockY; y >= minBlockY; --y) {
                        mutablePos.method_10103(x, y, z);
                        class_3610 fluidState = this.level.method_8316((class_2338)mutablePos);
                        if (fluidState.method_15769()) continue;
                        totalSurfaceHeight += (float)y + fluidState.method_15763((class_1922)this.level, (class_2338)mutablePos);
                        ++fluidColumnCount;
                        if (fluidState.method_15767(class_3486.field_15517)) {
                            detectedType = VxFluidType.WATER;
                            continue block2;
                        }
                        if (!fluidState.method_15767(class_3486.field_15518)) continue block2;
                        detectedType = VxFluidType.LAVA;
                        continue block2;
                    }
                }
            }
            if (fluidColumnCount <= 0 || detectedType == null || !((averageSurfaceHeight = totalSurfaceHeight / (float)fluidColumnCount) > minY) || (vxBody = this.physicsWorld.getBodyManager().getVxBody(id)) == null) continue;
            dataStore.add(vxBody.getBodyId(), averageSurfaceHeight, detectedType);
        }
    }
}

