/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.input;

import java.util.Objects;
import net.minecraft.class_2540;

public class VxMountInput {
    public static final VxMountInput NEUTRAL = new VxMountInput(false, false, false, false, false, false);
    private final boolean forward;
    private final boolean backward;
    private final boolean left;
    private final boolean right;
    private final boolean up;
    private final boolean down;

    public VxMountInput(boolean forward, boolean backward, boolean left, boolean right, boolean up, boolean down) {
        this.forward = forward;
        this.backward = backward;
        this.left = left;
        this.right = right;
        this.up = up;
        this.down = down;
    }

    public VxMountInput(class_2540 buf) {
        byte packed = buf.readByte();
        this.forward = (packed & 1) != 0;
        this.backward = (packed & 2) != 0;
        this.left = (packed & 4) != 0;
        this.right = (packed & 8) != 0;
        this.up = (packed & 0x10) != 0;
        this.down = (packed & 0x20) != 0;
    }

    public void encode(class_2540 buf) {
        int packed = 0;
        if (this.forward) {
            packed |= 1;
        }
        if (this.backward) {
            packed |= 2;
        }
        if (this.left) {
            packed |= 4;
        }
        if (this.right) {
            packed |= 8;
        }
        if (this.up) {
            packed |= 0x10;
        }
        if (this.down) {
            packed |= 0x20;
        }
        buf.writeByte(packed);
    }

    public boolean isForward() {
        return this.forward;
    }

    public boolean isBackward() {
        return this.backward;
    }

    public boolean isLeft() {
        return this.left;
    }

    public boolean isRight() {
        return this.right;
    }

    public boolean isUp() {
        return this.up;
    }

    public boolean isDown() {
        return this.down;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VxMountInput rideInput = (VxMountInput)o;
        return this.forward == rideInput.forward && this.backward == rideInput.backward && this.left == rideInput.left && this.right == rideInput.right && this.up == rideInput.up && this.down == rideInput.down;
    }

    public int hashCode() {
        return Objects.hash(this.forward, this.backward, this.left, this.right, this.up, this.down);
    }
}

