/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.raycasting;

import com.github.stephengold.joltjni.BodyFilter;
import com.github.stephengold.joltjni.BodyLockRead;
import com.github.stephengold.joltjni.BroadPhaseLayerFilter;
import com.github.stephengold.joltjni.ClosestHitCastRayCollector;
import com.github.stephengold.joltjni.ObjectLayerFilter;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.RRayCast;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.RayCastResult;
import com.github.stephengold.joltjni.RayCastSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.ConstNarrowPhaseQuery;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.Optional;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxPhysicsRaycaster {
    private VxPhysicsRaycaster() {
    }

    /*
     * Exception decompiling
     */
    public static Optional<Result> raycast(VxPhysicsWorld physicsWorld, RVec3 rayOrigin, Vec3 rayDirection, float maxDistance) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Optional<Result> raycast(VxPhysicsWorld physicsWorld, RVec3 rayOrigin, Vec3 rayDirection, float maxDistance, ObjectLayerFilter objectLayerFilter) {
        try (BroadPhaseLayerFilter bplFilter = new BroadPhaseLayerFilter();){
            Optional<Result> optional;
            try (BodyFilter bodyFilter = new BodyFilter();){
                optional = VxPhysicsRaycaster.raycast(physicsWorld, rayOrigin, rayDirection, maxDistance, bplFilter, objectLayerFilter, bodyFilter);
            }
            return optional;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Result> raycast(VxPhysicsWorld physicsWorld, RVec3 rayOrigin, Vec3 rayDirection, float maxDistance, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter) {
        if (physicsWorld == null) return Optional.empty();
        if (!physicsWorld.isRunning()) return Optional.empty();
        if (physicsWorld.getPhysicsSystem() == null) {
            return Optional.empty();
        }
        PhysicsSystem physicsSystem = physicsWorld.getPhysicsSystem();
        ConstNarrowPhaseQuery narrowPhaseQuery = physicsSystem.getNarrowPhaseQuery();
        Vec3 directionAndLength = Op.star((Vec3Arg)rayDirection, maxDistance);
        try (RRayCast ray = new RRayCast(rayOrigin, directionAndLength);
             RayCastSettings settings = new RayCastSettings();
             ClosestHitCastRayCollector collector = new ClosestHitCastRayCollector();){
            narrowPhaseQuery.castRay(ray, settings, collector, bplFilter, olFilter, bodyFilter);
            if (!collector.hadHit()) return Optional.empty();
            RayCastResult hit = collector.getHit();
            float hitFraction = hit.getFraction();
            RVec3 hitPointR = ray.getPointOnRay(hitFraction);
            int bodyId = hit.getBodyId();
            try (BodyLockRead lock = new BodyLockRead(physicsSystem.getBodyLockInterface(), bodyId);){
                if (!lock.succeededAndIsInBroadPhase()) return Optional.empty();
                Vec3 hitNormal = lock.getBody().getWorldSpaceSurfaceNormal(hit.getSubShapeId2(), hitPointR);
                Optional<Result> optional = Optional.of(new Result(bodyId, hitPointR, hitNormal, hitFraction));
                return optional;
            }
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Exception during physics raycast", (Throwable)e);
        }
        return Optional.empty();
    }

    public record Result(int bodyId, RVec3 hitPoint, Vec3 hitNormal, float hitFraction) {
    }
}

