/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.raycasting;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.xmx.velthoric.physics.raycasting.VxClipContext;
import net.xmx.velthoric.physics.raycasting.VxHitResult;
import net.xmx.velthoric.physics.raycasting.VxObjectLayerFilters;
import net.xmx.velthoric.physics.raycasting.VxPhysicsRaycaster;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxRaycaster {
    private VxRaycaster() {
    }

    public static Optional<VxHitResult> raycast(class_1937 level, VxClipContext context) {
        class_243 from = context.method_17750();
        class_243 to = context.method_17747();
        ArrayList hits = new ArrayList();
        VxRaycaster.raycastMinecraft(level, context).ifPresent(hits::add);
        if (context.isIncludePhysics()) {
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)level.method_27983());
            double maxDistance = from.method_1022(to);
            class_243 direction = to.method_1020(from).method_1029();
            RVec3 rayOrigin = new RVec3((float)from.field_1352, (float)from.field_1351, (float)from.field_1350);
            Vec3 rayDirection = new Vec3((float)direction.field_1352, (float)direction.field_1351, (float)direction.field_1350);
            VxRaycaster.raycastPhysics(physicsWorld, rayOrigin, rayDirection, (float)maxDistance).ifPresent(hits::add);
        }
        return hits.stream().min(Comparator.comparingDouble(hit -> hit.method_17784().method_1025(from)));
    }

    public static Optional<VxHitResult> raycastMinecraft(class_1937 level, VxClipContext context) {
        double entityHitSq;
        Predicate<class_1297> entityPredicate;
        class_238 searchBox;
        class_3966 entityHitResult;
        class_243 from = context.method_17750();
        class_243 to = context.method_17747();
        class_3965 blockHitResult = level.method_17742((class_3959)context);
        double closestHitSq = blockHitResult.method_17783() == class_239.class_240.field_1333 ? Double.MAX_VALUE : blockHitResult.method_17784().method_1025(from);
        class_3965 finalHit = blockHitResult;
        class_1297 entity = context.getEntity();
        if (entity != null && (entityHitResult = class_1675.method_18077((class_1937)level, (class_1297)entity, (class_243)from, (class_243)to, (class_238)(searchBox = new class_238(from, to)), entityPredicate = e -> !e.method_7325() && e.method_5863())) != null && (entityHitSq = entityHitResult.method_17784().method_1025(from)) < closestHitSq) {
            finalHit = entityHitResult;
        }
        return finalHit.method_17783() != class_239.class_240.field_1333 ? Optional.of(new VxHitResult((class_239)finalHit)) : Optional.empty();
    }

    public static Optional<VxHitResult> raycastPhysics(VxPhysicsWorld physicsWorld, RVec3 rayOrigin, Vec3 rayDirection, float maxDistance) {
        Optional<VxPhysicsRaycaster.Result> physicsResult = VxPhysicsRaycaster.raycast(physicsWorld, rayOrigin, rayDirection, maxDistance, VxObjectLayerFilters.IGNORE_TERRAIN);
        return physicsResult.map(hit -> {
            RVec3 hitPointR = hit.hitPoint();
            class_243 hitPoint = new class_243(hitPointR.xx(), hitPointR.yy(), hitPointR.zz());
            return new VxHitResult(hitPoint, hit.bodyId(), hit.hitNormal(), hit.hitFraction());
        });
    }
}

