/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AaBox;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public final class AaBoxCast
extends JoltPhysicsObject {
    public AaBoxCast() {
        long boxCastVa = AaBoxCast.createDefault();
        this.setVirtualAddress(boxCastVa, () -> AaBoxCast.free(boxCastVa));
    }

    public AaBoxCast(AaBoxCast original) {
        long originalVa = original.va();
        long copyVa = AaBoxCast.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> AaBoxCast.free(copyVa));
    }

    public AaBox getBox() {
        long boxCastVa = this.va();
        long boxVa = AaBoxCast.getBox(boxCastVa);
        AaBox result = new AaBox(this, boxVa);
        return result;
    }

    public Vec3 getDirection() {
        long boxCastVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        AaBoxCast.getDirection(boxCastVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public void setBox(ConstAaBox box) {
        long boxCastVa = this.va();
        long boxVa = box.targetVa();
        AaBoxCast.setBox(boxCastVa, boxVa);
    }

    public void setDirection(Vec3Arg offset) {
        long boxCastVa = this.va();
        float dx = offset.getX();
        float dy = offset.getY();
        float dz = offset.getZ();
        AaBoxCast.setDirection(boxCastVa, dx, dy, dz);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native long getBox(long var0);

    private static native void getDirection(long var0, FloatBuffer var2);

    private static native void setBox(long var0, long var2);

    private static native void setDirection(long var0, float var2, float var3, float var4);
}

