/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CollidePointCollector;
import com.github.stephengold.joltjni.CollidePointResult;
import java.util.ArrayList;
import java.util.List;

public class AllHitCollidePointCollector
extends CollidePointCollector {
    public AllHitCollidePointCollector() {
        long collectorVa = AllHitCollidePointCollector.createDefault();
        this.setVirtualAddressAsOwner(collectorVa);
    }

    public int countHits() {
        long collectorVa = this.va();
        int result = AllHitCollidePointCollector.countHits(collectorVa);
        return result;
    }

    public CollidePointResult get(int index) {
        long collectorVa = this.va();
        long hitVa = AllHitCollidePointCollector.getHit(collectorVa, index);
        CollidePointResult result = new CollidePointResult(this, hitVa);
        return result;
    }

    public List<CollidePointResult> getHits() {
        long collectorVa = this.va();
        int numHits = AllHitCollidePointCollector.countHits(collectorVa);
        ArrayList<CollidePointResult> result = new ArrayList<CollidePointResult>(numHits);
        for (int i = 0; i < numHits; ++i) {
            long hitVa = AllHitCollidePointCollector.getHit(collectorVa, i);
            CollidePointResult hit = new CollidePointResult(this, hitVa);
            result.add(hit);
        }
        return result;
    }

    public void sort() {
        long collectorVa = this.va();
        AllHitCollidePointCollector.sort(collectorVa);
    }

    @Override
    public void reset() {
        long collectorVa = this.va();
        AllHitCollidePointCollector.reset(collectorVa);
    }

    private static native int countHits(long var0);

    private static native long createDefault();

    private static native long getHit(long var0, int var2);

    private static native void reset(long var0);

    private static native void sort(long var0);
}

