/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import java.nio.IntBuffer;
import java.util.List;

public class BodyIdArray
extends JoltPhysicsObject {
    private final int length;

    public BodyIdArray(int length) {
        assert (length > 0) : "length=" + length;
        this.length = length;
        long arrayVa = BodyIdArray.create(length);
        this.setVirtualAddress(arrayVa, () -> BodyIdArray.free(arrayVa));
    }

    public BodyIdArray(int ... idArray) {
        this.length = idArray.length;
        assert (this.length > 0) : "length=" + this.length;
        IntBuffer intBuffer = Jolt.newDirectIntBuffer(this.length);
        intBuffer.put(idArray);
        long arrayVa = BodyIdArray.createFromBuffer(intBuffer);
        this.setVirtualAddress(arrayVa, () -> BodyIdArray.free(arrayVa));
    }

    public BodyIdArray(IntBuffer idBuffer) {
        assert (idBuffer.isDirect());
        this.length = idBuffer.capacity();
        assert (this.length > 0) : "length=" + this.length;
        long arrayVa = BodyIdArray.createFromBuffer(idBuffer);
        this.setVirtualAddress(arrayVa, () -> BodyIdArray.free(arrayVa));
    }

    public BodyIdArray(List<Integer> idList) {
        this.length = idList.size();
        assert (this.length > 0) : "length=" + this.length;
        IntBuffer intBuffer = Jolt.newDirectIntBuffer(this.length);
        for (int bodyId : idList) {
            intBuffer.put(bodyId);
        }
        long arrayVa = BodyIdArray.createFromBuffer(intBuffer);
        this.setVirtualAddress(arrayVa, () -> BodyIdArray.free(arrayVa));
    }

    public int get(int elementIndex) {
        assert (elementIndex >= 0 && elementIndex < this.length) : "Out of range:  index=" + elementIndex + " length=" + this.length;
        long arrayVa = this.va();
        int result = BodyIdArray.getId(arrayVa, elementIndex);
        return result;
    }

    public int length() {
        return this.length;
    }

    public void set(int elementIndex, int bodyId) {
        assert (elementIndex >= 0 && elementIndex < this.length) : "Out of range:  index=" + elementIndex + " length=" + this.length;
        long arrayVa = this.va();
        BodyIdArray.setId(arrayVa, elementIndex, bodyId);
    }

    private static native long create(int var0);

    private static native long createFromBuffer(IntBuffer var0);

    private static native void free(long var0);

    private static native int getId(long var0, int var2);

    private static native void setId(long var0, int var2, int var3);
}

