/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyIdArray;
import com.github.stephengold.joltjni.BroadPhaseLayerFilter;
import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.ObjectLayerFilter;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TransformedShape;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.github.stephengold.joltjni.enumerate.EMotionQuality;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstBody;
import com.github.stephengold.joltjni.readonly.ConstBodyCreationSettings;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyCreationSettings;
import com.github.stephengold.joltjni.readonly.ConstTwoBodyConstraint;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class BodyInterface
extends NonCopyable {
    BodyInterface(PhysicsSystem system, long bodyInterfaceVa) {
        super(system, bodyInterfaceVa);
    }

    public void activateBodiesInAaBox(ConstAaBox box, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        long bodyInterfaceVa = this.va();
        long boxVa = box.targetVa();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        BodyInterface.activateBodiesInAaBox(bodyInterfaceVa, boxVa, bplFilterVa, olFilterVa);
    }

    public void activateBody(int bodyId) {
        long bodyInterfaceVa = this.va();
        BodyInterface.activateBody(bodyInterfaceVa, bodyId);
    }

    public void activateConstraint(ConstTwoBodyConstraint constraint) {
        long bodyInterfaceVa = this.va();
        long constraintVa = constraint.targetVa();
        BodyInterface.activateConstraint(bodyInterfaceVa, constraintVa);
    }

    public void addAngularImpulse(int bodyId, Vec3Arg angularImpulse) {
        long bodyInterfaceVa = this.va();
        float lx = angularImpulse.getX();
        float ly = angularImpulse.getY();
        float lz = angularImpulse.getZ();
        BodyInterface.addAngularImpulse(bodyInterfaceVa, bodyId, lx, ly, lz);
    }

    public void addBodiesAbort(BodyIdArray bodyIds, long addState) {
        int numBodies = bodyIds.length();
        this.addBodiesAbort(bodyIds, numBodies, addState);
    }

    public void addBodiesAbort(BodyIdArray bodyIds, int numBodies, long addState) {
        long bodyInterfaceVa = this.va();
        long arrayVa = bodyIds.va();
        BodyInterface.addBodiesAbort(bodyInterfaceVa, arrayVa, numBodies, addState);
    }

    public void addBodiesFinalize(BodyIdArray bodyIds, long addState, EActivation activation) {
        int numBodies = bodyIds.length();
        this.addBodiesFinalize(bodyIds, numBodies, addState, activation);
    }

    public void addBodiesFinalize(BodyIdArray bodyIds, int numBodies, long addState, EActivation activation) {
        long bodyInterfaceVa = this.va();
        long arrayVa = bodyIds.va();
        int activationOrdinal = activation.ordinal();
        BodyInterface.addBodiesFinalize(bodyInterfaceVa, arrayVa, numBodies, addState, activationOrdinal);
    }

    public long addBodiesPrepare(BodyIdArray bodyIds) {
        int numBodies = bodyIds.length();
        long result = this.addBodiesPrepare(bodyIds, numBodies);
        return result;
    }

    public long addBodiesPrepare(BodyIdArray bodyIds, int numBodies) {
        long bodyInterfaceVa = this.va();
        long arrayVa = bodyIds.va();
        long result = BodyInterface.addBodiesPrepare(bodyInterfaceVa, arrayVa, numBodies);
        return result;
    }

    public void addBody(ConstBody body, EActivation activation) {
        long bodyInterfaceVa = this.va();
        long bodyVa = body.targetVa();
        int bodyId = Body.getId(bodyVa);
        int activationOrdinal = activation.ordinal();
        BodyInterface.addBody(bodyInterfaceVa, bodyId, activationOrdinal);
    }

    public void addBody(int bodyId, EActivation activation) {
        long bodyInterfaceVa = this.va();
        int activationOrdinal = activation.ordinal();
        BodyInterface.addBody(bodyInterfaceVa, bodyId, activationOrdinal);
    }

    public void addForce(int bodyId, Vec3Arg force) {
        long bodyInterfaceVa = this.va();
        float fx = force.getX();
        float fy = force.getY();
        float fz = force.getZ();
        BodyInterface.addForce(bodyInterfaceVa, bodyId, fx, fy, fz);
    }

    public void addForce(int bodyId, Vec3Arg force, RVec3Arg location) {
        long bodyInterfaceVa = this.va();
        float fx = force.getX();
        float fy = force.getY();
        float fz = force.getZ();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        BodyInterface.addForce(bodyInterfaceVa, bodyId, fx, fy, fz, locX, locY, locZ);
    }

    public void addImpulse(int bodyId, Vec3Arg impulse) {
        long bodyInterfaceVa = this.va();
        float jx = impulse.getX();
        float jy = impulse.getY();
        float jz = impulse.getZ();
        BodyInterface.addImpulse(bodyInterfaceVa, bodyId, jx, jy, jz);
    }

    public void addImpulse(int bodyId, Vec3Arg impulse, RVec3Arg location) {
        long bodyInterfaceVa = this.va();
        float jx = impulse.getX();
        float jy = impulse.getY();
        float jz = impulse.getZ();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        BodyInterface.addImpulse(bodyInterfaceVa, bodyId, jx, jy, jz, locX, locY, locZ);
    }

    public void addTorque(int bodyId, Vec3Arg torque) {
        long bodyInterfaceVa = this.va();
        float x = torque.getX();
        float y = torque.getY();
        float z = torque.getZ();
        BodyInterface.addTorque(bodyInterfaceVa, bodyId, x, y, z);
    }

    public int createAndAddBody(ConstBodyCreationSettings settings, EActivation activationMode) {
        Body body = this.createBody(settings);
        int result = body.getId();
        this.addBody(result, activationMode);
        return result;
    }

    public int createAndAddSoftBody(ConstSoftBodyCreationSettings settings, EActivation activationMode) {
        Body body = this.createSoftBody(settings);
        int result = body.getId();
        this.addBody(result, activationMode);
        return result;
    }

    public Body createBody(ConstBodyCreationSettings settings) {
        long settingsVa;
        PhysicsSystem system = this.getSystem();
        assert (system.getMaxBodies() > 0) : "The PhysicsSystem appears to be uninitialized.";
        long bodyInterfaceVa = this.va();
        long bodyVa = BodyInterface.createBody(bodyInterfaceVa, settingsVa = settings.targetVa());
        if (bodyVa == 0L) {
            throw new IllegalStateException("ran out of bodies");
        }
        Body result = new Body(system, bodyVa);
        return result;
    }

    public TwoBodyConstraint createConstraint(TwoBodyConstraintSettings settings, int rigidBody1Id, int rigidBody2Id) {
        long bodyInterfaceVa = this.va();
        long settingsVa = settings.va();
        assert (BodyInterface.getBodyType(bodyInterfaceVa, rigidBody1Id) == EBodyType.RigidBody.ordinal()) : "body1 must be a rigid body.";
        assert (BodyInterface.getBodyType(bodyInterfaceVa, rigidBody2Id) == EBodyType.RigidBody.ordinal()) : "body2 must be a rigid body.";
        long constraintVa = BodyInterface.createConstraint(bodyInterfaceVa, settingsVa, rigidBody1Id, rigidBody2Id);
        TwoBodyConstraint result = (TwoBodyConstraint)Constraint.newConstraint(constraintVa);
        return result;
    }

    public Body createSoftBody(ConstSoftBodyCreationSettings settings) {
        long settingsVa;
        long bodyInterfaceVa = this.va();
        long bodyVa = BodyInterface.createSoftBody(bodyInterfaceVa, settingsVa = settings.targetVa());
        if (bodyVa == 0L) {
            throw new IllegalStateException("ran out of bodies");
        }
        PhysicsSystem system = this.getSystem();
        Body result = new Body(system, bodyVa);
        return result;
    }

    public void deactivateBody(int bodyId) {
        long bodyInterfaceVa = this.va();
        BodyInterface.deactivateBody(bodyInterfaceVa, bodyId);
    }

    public void destroyBodies(BodyIdArray bodyIds) {
        int numBodies = bodyIds.length();
        this.destroyBodies(bodyIds, numBodies);
    }

    public void destroyBodies(BodyIdArray bodyIds, int numBodies) {
        long bodyInterfaceVa = this.va();
        long arrayVa = bodyIds.va();
        BodyInterface.destroyBodies(bodyInterfaceVa, arrayVa, numBodies);
    }

    public void destroyBody(int bodyId) {
        long bodyInterfaceVa = this.va();
        BodyInterface.destroyBody(bodyInterfaceVa, bodyId);
    }

    public Vec3 getAngularVelocity(int bodyId) {
        long bodyInterfaceVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BodyInterface.getAngularVelocity(bodyInterfaceVa, bodyId, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public void getAngularVelocity(int bodyId, Vec3 storeVelocity) {
        long bodyInterfaceVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BodyInterface.getAngularVelocity(bodyInterfaceVa, bodyId, storeFloats);
        storeVelocity.set(storeFloats);
    }

    public EBodyType getBodyType(int bodyId) {
        long bodyInterfaceVa = this.va();
        int ordinal = BodyInterface.getBodyType(bodyInterfaceVa, bodyId);
        EBodyType result = EBodyType.values()[ordinal];
        return result;
    }

    public RVec3 getCenterOfMassPosition(int bodyId) {
        long bodyInterfaceVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        BodyInterface.getCenterOfMassPosition(bodyInterfaceVa, bodyId, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public RMat44 getCenterOfMassTransform(int bodyId) {
        long bodyInterfaceVa = this.va();
        long matrixVa = BodyInterface.getCenterOfMassTransform(bodyInterfaceVa, bodyId);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    public float getFriction(int bodyId) {
        long bodyInterfaceVa = this.va();
        float result = BodyInterface.getFriction(bodyInterfaceVa, bodyId);
        return result;
    }

    public float getGravityFactor(int bodyId) {
        long bodyInterfaceVa = this.va();
        float result = BodyInterface.getGravityFactor(bodyInterfaceVa, bodyId);
        return result;
    }

    public Vec3 getLinearVelocity(int bodyId) {
        long bodyInterfaceVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BodyInterface.getLinearVelocity(bodyInterfaceVa, bodyId, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public void getLinearVelocity(int bodyId, Vec3 storeVelocity) {
        long bodyInterfaceVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BodyInterface.getLinearVelocity(bodyInterfaceVa, bodyId, storeFloats);
        storeVelocity.set(storeFloats);
    }

    public Mat44 getInverseInertia(int bodyId) {
        long bodyInterfaceVa = this.va();
        long matrixVa = BodyInterface.getInverseInertia(bodyInterfaceVa, bodyId);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public EMotionQuality getMotionQuality(int bodyId) {
        long bodyInterfaceVa = this.va();
        int ordinal = BodyInterface.getMotionQuality(bodyInterfaceVa, bodyId);
        EMotionQuality result = EMotionQuality.values()[ordinal];
        return result;
    }

    public EMotionType getMotionType(int bodyId) {
        long bodyInterfaceVa = this.va();
        int ordinal = BodyInterface.getMotionType(bodyInterfaceVa, bodyId);
        EMotionType result = EMotionType.values()[ordinal];
        return result;
    }

    public int getObjectLayer(int bodyId) {
        long bodyInterfaceVa = this.va();
        int result = BodyInterface.getObjectLayer(bodyInterfaceVa, bodyId);
        return result;
    }

    public RVec3 getPosition(int bodyId) {
        long bodyInterfaceVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        BodyInterface.getPosition(bodyInterfaceVa, bodyId, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public void getPosition(int bodyId, RVec3 storeLocation) {
        long bodyInterfaceVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        BodyInterface.getPosition(bodyInterfaceVa, bodyId, storeDoubles);
        storeLocation.set(storeDoubles);
    }

    public void getPositionAndRotation(int bodyId, RVec3 storeLocation, Quat storeOrientation) {
        long bodyInterfaceVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BodyInterface.getPositionAndRotation(bodyInterfaceVa, bodyId, storeDoubles, storeFloats);
        storeLocation.set(storeDoubles);
        storeOrientation.set(storeFloats);
    }

    public float getRestitution(int bodyId) {
        long bodyInterfaceVa = this.va();
        float result = BodyInterface.getRestitution(bodyInterfaceVa, bodyId);
        return result;
    }

    public Quat getRotation(int bodyId) {
        long bodyInterfaceVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BodyInterface.getRotation(bodyInterfaceVa, bodyId, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    public void getRotation(int bodyId, Quat storeOrientation) {
        long bodyInterfaceVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BodyInterface.getRotation(bodyInterfaceVa, bodyId, storeFloats);
        storeOrientation.set(storeFloats);
    }

    public ShapeRefC getShape(int bodyId) {
        long bodyInterfaceVa = this.va();
        long shapeRefVa = BodyInterface.getShape(bodyInterfaceVa, bodyId);
        ShapeRefC result = new ShapeRefC(shapeRefVa, true);
        return result;
    }

    public PhysicsSystem getSystem() {
        PhysicsSystem result = (PhysicsSystem)this.getContainingObject();
        return result;
    }

    public TransformedShape getTransformedShape(int bodyId) {
        long bodyInterfaceVa = this.va();
        long shapeVa = BodyInterface.getTransformedShape(bodyInterfaceVa, bodyId);
        TransformedShape result = new TransformedShape(shapeVa, true);
        return result;
    }

    public boolean getUseManifoldReduction(int bodyId) {
        long bodyInterfaceVa = this.va();
        boolean result = BodyInterface.getUseManifoldReduction(bodyInterfaceVa, bodyId);
        return result;
    }

    public long getUserData(int bodyId) {
        long bodyInterfaceVa = this.va();
        long result = BodyInterface.getUserData(bodyInterfaceVa, bodyId);
        return result;
    }

    public boolean isActive(int bodyId) {
        long bodyInterfaceVa = this.va();
        boolean result = BodyInterface.isActive(bodyInterfaceVa, bodyId);
        return result;
    }

    public boolean isAdded(int bodyId) {
        long bodyInterfaceVa = this.va();
        boolean result = BodyInterface.isAdded(bodyInterfaceVa, bodyId);
        return result;
    }

    public boolean isSensor(int bodyId) {
        long bodyInterfaceVa = this.va();
        boolean result = BodyInterface.isSensor(bodyInterfaceVa, bodyId);
        return result;
    }

    public void moveKinematic(int bodyId, RVec3Arg location, QuatArg orientation, float deltaTime) {
        long bodyInterfaceVa = this.va();
        double xx = location.xx();
        double yy = location.yy();
        double zz = location.zz();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        BodyInterface.moveKinematic(bodyInterfaceVa, bodyId, xx, yy, zz, qx, qy, qz, qw, deltaTime);
    }

    public void notifyShapeChanged(int bodyId, Vec3Arg prevCom, boolean updateMassProperties, EActivation activation) {
        long bodyInterfaceVa = this.va();
        int activationOrdinal = activation.ordinal();
        BodyInterface.notifyShapeChanged(bodyInterfaceVa, bodyId, prevCom.getX(), prevCom.getY(), prevCom.getZ(), updateMassProperties, activationOrdinal);
    }

    public void removeBodies(BodyIdArray bodyIds) {
        int numBodies = bodyIds.length();
        this.removeBodies(bodyIds, numBodies);
    }

    public void removeBodies(BodyIdArray bodyIds, int numBodies) {
        long bodyInterfaceVa = this.va();
        long arrayVa = bodyIds.va();
        BodyInterface.removeBodies(bodyInterfaceVa, arrayVa, numBodies);
    }

    public void removeBody(int bodyId) {
        long bodyInterfaceVa = this.va();
        BodyInterface.removeBody(bodyInterfaceVa, bodyId);
    }

    public void setAngularVelocity(int bodyId, Vec3Arg omega) {
        long bodyInterfaceVa = this.va();
        BodyInterface.setAngularVelocity(bodyInterfaceVa, bodyId, omega.getX(), omega.getY(), omega.getZ());
    }

    public void setFriction(int bodyId, float friction) {
        long bodyInterfaceVa = this.va();
        BodyInterface.setFriction(bodyInterfaceVa, bodyId, friction);
    }

    public void setGravityFactor(int bodyId, float factor) {
        long bodyInterfaceVa = this.va();
        BodyInterface.setGravityFactor(bodyInterfaceVa, bodyId, factor);
    }

    public void setIsSensor(int bodyId, boolean setting) {
        long bodyInterfaceVa = this.va();
        BodyInterface.setIsSensor(bodyInterfaceVa, bodyId, setting);
    }

    public void setLinearAndAngularVelocity(int bodyId, Vec3Arg linearVelocity, Vec3Arg angularVelocity) {
        long bodyInterfaceVa = this.va();
        float vx = linearVelocity.getX();
        float vy = linearVelocity.getY();
        float vz = linearVelocity.getZ();
        float wx = angularVelocity.getX();
        float wy = angularVelocity.getY();
        float wz = angularVelocity.getZ();
        BodyInterface.setLinearAndAngularVelocity(bodyInterfaceVa, bodyId, vx, vy, vz, wx, wy, wz);
    }

    public void setLinearVelocity(int bodyId, float vx, float vy, float vz) {
        long bodyInterfaceVa = this.va();
        BodyInterface.setLinearVelocity(bodyInterfaceVa, bodyId, vx, vy, vz);
    }

    public void setLinearVelocity(int bodyId, Vec3Arg velocity) {
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        this.setLinearVelocity(bodyId, vx, vy, vz);
    }

    public void setMotionQuality(int bodyId, EMotionQuality quality) {
        long bodyInterfaceVa = this.va();
        int ordinal = quality.ordinal();
        BodyInterface.setMotionQuality(bodyInterfaceVa, bodyId, ordinal);
    }

    public void setMotionType(int bodyId, EMotionType motionType, EActivation activationMode) {
        long bodyInterfaceVa = this.va();
        int motionOrdinal = motionType.ordinal();
        int activationOrdinal = activationMode.ordinal();
        BodyInterface.setMotionType(bodyInterfaceVa, bodyId, motionOrdinal, activationOrdinal);
    }

    public void setObjectLayer(int bodyId, int layer) {
        assert (layer >= 0 && layer < 65536) : "layer = " + layer;
        long bodyInterfaceVa = this.va();
        BodyInterface.setObjectLayer(bodyInterfaceVa, bodyId, layer);
    }

    public void setPosition(int bodyId, RVec3Arg location, EActivation activationMode) {
        long bodyInterfaceVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        int ordinal = activationMode.ordinal();
        BodyInterface.setPosition(bodyInterfaceVa, bodyId, locX, locY, locZ, ordinal);
    }

    public void setPositionAndRotation(int bodyId, RVec3Arg location, QuatArg orientation, EActivation activationMode) {
        long bodyInterfaceVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        int ordinal = activationMode.ordinal();
        BodyInterface.setPositionAndRotation(bodyInterfaceVa, bodyId, locX, locY, locZ, qx, qy, qz, qw, ordinal);
    }

    public void setRestitution(int bodyId, float restitution) {
        long bodyInterfaceVa = this.va();
        BodyInterface.setRestitution(bodyInterfaceVa, bodyId, restitution);
    }

    public void setShape(int bodyId, ConstShape shape, boolean updateMassProperties, EActivation activation) {
        long bodyInterfaceVa = this.va();
        long shapeVa = shape.targetVa();
        int ordinal = activation.ordinal();
        BodyInterface.setShape(bodyInterfaceVa, bodyId, shapeVa, updateMassProperties, ordinal);
    }

    public void setUserData(int bodyId, long value) {
        long bodyInterfaceVa = this.va();
        BodyInterface.setUserData(bodyInterfaceVa, bodyId, value);
    }

    private static native void activateBodiesInAaBox(long var0, long var2, long var4, long var6);

    private static native void activateBody(long var0, int var2);

    private static native void activateConstraint(long var0, long var2);

    private static native void addAngularImpulse(long var0, int var2, float var3, float var4, float var5);

    private static native void addBodiesAbort(long var0, long var2, int var4, long var5);

    private static native void addBodiesFinalize(long var0, long var2, int var4, long var5, int var7);

    private static native long addBodiesPrepare(long var0, long var2, int var4);

    private static native void addBody(long var0, int var2, int var3);

    private static native void addForce(long var0, int var2, float var3, float var4, float var5);

    private static native void addForce(long var0, int var2, float var3, float var4, float var5, double var6, double var8, double var10);

    private static native void addImpulse(long var0, int var2, float var3, float var4, float var5);

    private static native void addImpulse(long var0, int var2, float var3, float var4, float var5, double var6, double var8, double var10);

    private static native void addTorque(long var0, int var2, float var3, float var4, float var5);

    private static native long createBody(long var0, long var2);

    private static native long createConstraint(long var0, long var2, int var4, int var5);

    private static native long createSoftBody(long var0, long var2);

    private static native void deactivateBody(long var0, int var2);

    private static native void destroyBodies(long var0, long var2, int var4);

    private static native void destroyBody(long var0, int var2);

    private static native void getAngularVelocity(long var0, int var2, FloatBuffer var3);

    private static native int getBodyType(long var0, int var2);

    private static native void getCenterOfMassPosition(long var0, int var2, DoubleBuffer var3);

    private static native long getCenterOfMassTransform(long var0, int var2);

    private static native float getFriction(long var0, int var2);

    private static native float getGravityFactor(long var0, int var2);

    private static native long getInverseInertia(long var0, int var2);

    private static native void getLinearVelocity(long var0, int var2, FloatBuffer var3);

    private static native int getMotionQuality(long var0, int var2);

    private static native int getMotionType(long var0, int var2);

    private static native int getObjectLayer(long var0, int var2);

    private static native void getPosition(long var0, int var2, DoubleBuffer var3);

    private static native void getPositionAndRotation(long var0, int var2, DoubleBuffer var3, FloatBuffer var4);

    private static native float getRestitution(long var0, int var2);

    private static native void getRotation(long var0, int var2, FloatBuffer var3);

    private static native long getShape(long var0, int var2);

    private static native long getTransformedShape(long var0, int var2);

    private static native long getUserData(long var0, int var2);

    private static native boolean getUseManifoldReduction(long var0, int var2);

    private static native boolean isActive(long var0, int var2);

    private static native boolean isAdded(long var0, int var2);

    private static native boolean isSensor(long var0, int var2);

    private static native void moveKinematic(long var0, int var2, double var3, double var5, double var7, float var9, float var10, float var11, float var12, float var13);

    private static native void notifyShapeChanged(long var0, int var2, float var3, float var4, float var5, boolean var6, int var7);

    private static native void removeBodies(long var0, long var2, int var4);

    private static native void removeBody(long var0, int var2);

    private static native void setAngularVelocity(long var0, int var2, float var3, float var4, float var5);

    private static native void setFriction(long var0, int var2, float var3);

    private static native void setGravityFactor(long var0, int var2, float var3);

    private static native void setIsSensor(long var0, int var2, boolean var3);

    private static native void setLinearAndAngularVelocity(long var0, int var2, float var3, float var4, float var5, float var6, float var7, float var8);

    private static native void setLinearVelocity(long var0, int var2, float var3, float var4, float var5);

    private static native void setMotionQuality(long var0, int var2, int var3);

    private static native void setMotionType(long var0, int var2, int var3, int var4);

    private static native void setObjectLayer(long var0, int var2, int var3);

    private static native void setPosition(long var0, int var2, double var3, double var5, double var7, int var9);

    private static native void setPositionAndRotation(long var0, int var2, double var3, double var5, double var7, float var9, float var10, float var11, float var12, int var13);

    private static native void setRestitution(long var0, int var2, float var3);

    private static native void setShape(long var0, int var2, long var3, boolean var5, int var6);

    private static native void setUserData(long var0, int var2, long var3);
}

