/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ChbFace;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EResult;
import com.github.stephengold.joltjni.readonly.ConstChbFace;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;
import java.util.Collection;

public class ConvexHullBuilder
extends NonCopyable {
    public ConvexHullBuilder(Collection<?> points) {
        int numPoints = points.size();
        int numFloats = 3 * numPoints;
        FloatBuffer pointBuffer = Jolt.newDirectFloatBuffer(numFloats);
        for (Object element : points) {
            Vec3Arg point = (Vec3Arg)element;
            point.put(pointBuffer);
        }
        long builderVa = ConvexHullBuilder.create(pointBuffer);
        this.setVirtualAddress(builderVa, () -> ConvexHullBuilder.free(builderVa));
    }

    public void determineMaxError(ChbFace[] storeFaceWithMaxError, float[] storeMaxError, int[] storePositionIndex, float[] storeCoplanarDistance) {
        ChbFace face;
        long builderVa = this.va();
        long[] storeFaceVa = new long[1];
        ConvexHullBuilder.determineMaxError(builderVa, storeFaceVa, storeMaxError, storePositionIndex, storeCoplanarDistance);
        storeFaceWithMaxError[0] = storeFaceVa[0] == 0L ? null : (face = new ChbFace(this, storeFaceVa[0]));
    }

    public void getCenterOfMassAndVolume(Vec3 storeCom, float[] storeVolume) {
        long builderVa = this.va();
        float[] storeFloats = new float[4];
        ConvexHullBuilder.getCenterOfMassAndVolume(builderVa, storeFloats);
        storeCom.set(storeFloats);
        storeVolume[0] = storeFloats[3];
    }

    public ConstChbFace[] getFaces() {
        long builderVa = this.va();
        int numFaces = ConvexHullBuilder.countFaces(builderVa);
        long[] storeVas = new long[numFaces];
        ConvexHullBuilder.getFaces(builderVa, storeVas);
        ConstChbFace[] result = new ChbFace[numFaces];
        for (int i = 0; i < numFaces; ++i) {
            long faceVa = storeVas[i];
            result[i] = new ChbFace(this, faceVa);
        }
        return result;
    }

    public EResult initialize(int maxVertices, float tolerance, String[] storeMessage) {
        long builderVa = this.va();
        int ordinal = ConvexHullBuilder.initialize(builderVa, maxVertices, tolerance, storeMessage);
        EResult result = EResult.values()[ordinal];
        return result;
    }

    private static native int countFaces(long var0);

    private static native long create(FloatBuffer var0);

    private static native void determineMaxError(long var0, long[] var2, float[] var3, int[] var4, float[] var5);

    private static native void free(long var0);

    private static native void getCenterOfMassAndVolume(long var0, float[] var2);

    private static native void getFaces(long var0, long[] var2);

    private static native int initialize(long var0, int var2, float var3, String[] var4);
}

